package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ReporteGeneralAction extends BaseAction {

	private static final long serialVersionUID = 1L;
	private List<EstudiosTransDTO> estudiosTrans;
	private List<ReporteGeneralDTO> reporteGeneral;
	private String estudio;
	private String fecha;
	private String fileName;
	private InputStream fileInputStream;
	private String mes;
	private String anio;

	@Autowired
	private TransaccionesBO transacciones;

	@Override
	public String execute() throws TransaccionException {
		setPmns();

		try {
			setEstudiosTrans(transacciones.getEstudiosTrans());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 215);
		this.getSession().put("pmnReturn", 215);
		this.setPmn("215");
		this.setPmnReturn("215");
	}

	public String generarReporte() throws TransaccionException {
		logger.info("Datos para reporte Fecha: " + fecha + " Estudio: " + estudio);
		String[] date = fecha.split("/");

		try {
			setReporteGeneral(transacciones.reporteGeneral(date[0], date[1], estudio));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		logger.info("Recuperando reporte: " + getReporteGeneral().size());
		return SUCCESS;
	}

	public String generarExcel() throws TransaccionException {
		logger.info("Datos para reporte Fecha: " + fecha + " Estudio: " + estudio);
		String[] date = fecha.split("/");

		try {
			setFileInputStream(transacciones.obtenerReporteEnExcel(date[0], date[1], estudio));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setFileName(date[0] + "-" + date[1] + "-01");
		setPmns();
		return SUCCESS;
	}

	public String cerrarReporte() throws TransaccionException {

		try {
			transacciones.cerrarRporte(getfecha());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String reabrirReporte() throws TransaccionException {

		try {
			transacciones.reabrirReporte(mes, anio);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String getfecha() {
		Integer year = Calendar.getInstance().get(Calendar.YEAR);
		Integer month = Calendar.getInstance().get(Calendar.MONTH);
		if (month == 0) {
			year = year - 1;
			month = 12;
		}
		setMes(StringUtils.leftPad(month.toString(), 2));
		setAnio(year.toString());
		return year.toString() + "-" + month.toString() + "-" + "01";
	}

}
