package com.mx.dla.dda.contrato.bdeal.actions;

import java.io.InputStream;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.bdeal.bos.BdealBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;

public class ExportarTitulosBdealAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private InputStream fileInputStream;
	private String fileName;
	private Long id;
	private String tipo;

	@Autowired
	private BdealBO bdealBO;

	public String execute() {

		Long idContrato = (Long) this.getSession().get("idContrato");
		fileInputStream = bdealBO.seleccionaTipoDescarga(tipo, id);
		fileName = tipo.equals("titulos") ? "[" + idContrato + "]" : "[" + idContrato + "]Errores";

		return SUCCESS;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFileName() {
		return fileName;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getId() {
		return id;
	}

	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	public String getTipo() {
		return tipo;
	}

}
