package com.mx.dla.dda.contrato.common.actions;

import java.io.File;
import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.bos.DocumentoBO;
import com.mx.dla.global.actions.BaseAction;

public class SubirDocumentoAction extends BaseAction {

	private static final long serialVersionUID = -1880333104009351799L;

	@Autowired
	private DocumentoBO documentoBO;

	private long idContrato;
	private Long idDoc;
	private File fileUpload;
	private String fileUploadContentType;
	private String fileUploadFileName;
	private String error;

	@Override
	public String execute() {
		try {
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");

			logger.debug("Remplzar {}", idDoc);
			if (this.getIdDoc() != null)
				documentoBO.remplazarDocumento(fileUpload, fileUploadFileName, usuario.getExpediente(),
						(Long) this.getSession().get("idContrato"), this.getIdDoc());
			else
				documentoBO.insertarDocumento(fileUpload, fileUploadFileName, usuario.getExpediente(),
						(Long) this.getSession().get("idContrato"));
		} catch (IOException e) {
			logger.error("Error al subir documento ", e);
			error = "Error al subir documento";
		}
		return SUCCESS;
	}

	public String upload() {
		return SUCCESS;
	}

	public long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(long idContrato) {
		this.idContrato = idContrato;
	}

	public File getFileUpload() {
		return fileUpload;
	}

	public void setFileUpload(File fileUpload) {
		this.fileUpload = fileUpload;
	}

	public String getFileUploadContentType() {
		return fileUploadContentType;
	}

	public void setFileUploadContentType(String fileUploadContentType) {
		this.fileUploadContentType = fileUploadContentType;
	}

	public String getFileUploadFileName() {
		return fileUploadFileName;
	}

	public void setFileUploadFileName(String fileUploadFileName) {
		this.fileUploadFileName = fileUploadFileName;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public Long getIdDoc() {
		return idDoc;
	}

	public void setIdDoc(Long idDoc) {
		this.idDoc = idDoc;
	}
}
