package com.mx.dla.dda.contrato.condicionesTransaccion.actions;

import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class CondicionesTransaccionAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	ContratoDTO contrato = new ContratoDTO();

	@Autowired
	private GeneralesBO generales;

	@Override
	public String execute() throws TransaccionException {

		this.setIdContrato((Long) this.getSession().get("idContrato"));
		buscarJustificaciones();
		try {
			contrato = generales.obtenContrato(getIdContrato());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		getSession().put("contrato", contrato);

		return SUCCESS;
	}

}
