package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.PermisoDTO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class ObtenerPermisosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<PermisoDTO> permisos;
	private AreaDTO area;
	private UsuarioDTO usuario;
	private Integer permisoSi;
	
	@Value("${login.uri}")
	private String uri;

	@Autowired
	private GeneralesBO generalesBO;
	
	@Autowired
	private UsuarioDAO usuarioDAO;

	@Override
	public String execute() throws TransaccionException {
		@SuppressWarnings("unchecked")
		List<PermisoDTO> permisosS = (List<PermisoDTO>) this.getSession().get("permisos");
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));
		try {
			setArea(generalesBO.obtenerAreaPorExpediente(getUsuario().getExpediente()));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPermisos(permisosS);
		if(!getPmn().equals("1")) {
			String pmnAux = getPmn().equals("-1") ? "1" : getPmn();
			if(tienePermiso(permisosS, pmnAux)) {
				System.out.println("Tiene permiso para " + getPmn());
				permisoSi = 1;
			} else {
				System.out.println("No tiene permiso para " + getPmn());
				logger.error("El usuario no tiene el permiso. {}", getPmn());
				String ipAdress = this.getSession().get("ipAdress").toString();
				String userAgent = this.getSession().get("userAgent").toString();
				usuarioDAO.insertaBitacoraPermiso(pmnAux, getUsuario().getExpediente(), ipAdress, userAgent);
				permisoSi = 0;
			}
		}
		return SUCCESS;
	}
	
	private boolean tienePermiso(List<PermisoDTO> permisos, String id) {
		for(PermisoDTO permiso : permisos) {
			if(permiso.getIdMenu().toString().equals(id)) {
				return true;
			}
		}
		return false;
	}

	public void setPermisos(List<PermisoDTO> permisos) {
		this.permisos = permisos;
	}

	public List<PermisoDTO> getPermisos() {
		return permisos;
	}

	public void setArea(AreaDTO area) {
		this.area = area;
	}

	public AreaDTO getArea() {
		return area;
	}

	public void setUsuario(UsuarioDTO usuario) {
		this.usuario = usuario;
	}

	public UsuarioDTO getUsuario() {
		return usuario;
	}

	public Integer getPermisoSi() {
		return permisoSi;
	}

	public void setPermisoSi(Integer permisoSi) {
		this.permisoSi = permisoSi;
	}

	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}
	
}
