package com.mx.dla.dda.contrato.minimum.actions;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.dda.contrato.minimum.bos.MinimunBO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimumPantallaDTO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimunDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.opensymphony.xwork2.Action;

public class MinimumAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	final static Logger logger = Logger.getLogger(MinimumAction.class);

	private List<MinimumPantallaDTO> listado = new ArrayList<MinimumPantallaDTO>();
	private List<MinimunDTO> listadoAct = new ArrayList<MinimunDTO>();
	private List<ReleaseDTO> releasses = new ArrayList<ReleaseDTO>();
	private List<JustificacionDTO> justificaciones;
	private String requestJson;
	private String msgError;
	private String msgExito;

	@Autowired
	private MinimunBO minimunBO;

	@Autowired
	private CatalogosBO catalogosBO;

	public String execute() {

		try {

			ReleaseDTO release = new ReleaseDTO();
			release.setDescripcion("Release Date(Days)");
			releasses.add(release);
			releasses.addAll(catalogosBO.getReleases());

			listado = minimunBO.getValoresMinimun(this.getIdContrato(), catalogosBO.getFormatos(),
					catalogosBO.getReleases(), catalogosBO.getPaises());
		} catch (PersistenceException e) {
			this.msgError = "Ocurrió un error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (SQLException e) {
			this.msgError = "Ocurrió un error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (TransaccionException e) {
			this.msgError = "Ocurrió un error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}

		return Action.SUCCESS;
	}

	public String obtenerJustificaciones() {

		try {
			logger.info("tipoContrato:" + this.getServletRequest().getParameter("tipoContrato"));
			this.buscarJustificaciones();
			this.getServletRequest().setAttribute("justificaciones", this.getJustificaciones());
			this.getServletRequest().setAttribute("jusListo", "1");
			this.getServletRequest().setAttribute("tipoContrato",
					this.getServletRequest().getParameter("tipoContrato"));

		} catch (PersistenceException ibe) {
			this.msgError = "Ocurrió un error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", ibe);

		}

		return Action.SUCCESS;
	}

	public String actualizarMinimuns() {

		ObjectMapper mapper = new ObjectMapper();

		try {

			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}

			listadoAct = mapper.readValue(requestJson,
					mapper.getTypeFactory().constructCollectionType(List.class, MinimunDTO.class));
			minimunBO.actualizarInformacion(listadoAct);

			this.msgExito = "Los datos fueron guardados con exito.";
		} catch (PersistenceException ibe) {
			this.msgError = "Ocurrió un error al realizar la operación.";
			logger.error("Error en [" + this.getClass() + "]", ibe);
		} catch (JsonParseException e) {
			this.msgError = "Ocurrió un error al realizar la operación.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (JsonMappingException e) {
			this.msgError = "Ocurrió un error al realizar la operación.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (IOException e) {
			this.msgError = "Ocurrió un error al realizar la operación.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}
		return Action.SUCCESS;
	}

	public List<MinimumPantallaDTO> getListado() {
		return listado;
	}

	public List<MinimunDTO> getListadoAct() {
		return listadoAct;
	}

	public void setListadoAct(List<MinimunDTO> listadoAct) {
		this.listadoAct = listadoAct;
	}

	public List<ReleaseDTO> getReleasses() {
		return releasses;
	}

	public String getMsgError() {
		return msgError;
	}

	public String getRequestJson() {
		return requestJson;
	}

	public void setRequestJson(String requestJson) {
		this.requestJson = requestJson;
	}

	public String getMsgExito() {
		return msgExito;
	}

	public void setMsgExito(String msgExito) {
		this.msgExito = msgExito;
	}

	public List<JustificacionDTO> getJustificaciones() {
		return justificaciones;
	}

	public void setJustificaciones(List<JustificacionDTO> justificaciones) {
		this.justificaciones = justificaciones;
	}

}
