package com.mx.dla.dda.contrato.transaccion.fees.actions;

import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesTransaccioBO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesEstDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesLibreriaDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesPremierDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTransaccionDTO;
import com.opensymphony.xwork2.Action;

public class FeesTAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private FeesPremierDTO feesPremierDTO;
	private FeesLibreriaDTO feesLibreriaDTO;
	private FeesEstDTO feesEstDTO;
	private FeesTransaccionDTO fees;
	private String tipoFees;
	private String error;
	private Long idCategMin;
	private Long idCto;
	private Long tipoCambio;

	@Autowired
	private FeesTransaccioBO feesTransaccioBO;

	public String obtenerPremierFees() {

		try {
			logger.debug("" + (Long) this.getSession().get("idContrato"));
			this.setIdContrato((Long) this.getSession().get("idContrato"));
			feesPremierDTO = feesTransaccioBO.obtenerPremierFees(this.getIdContrato());
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}

		return Action.SUCCESS;
	}

	public String obtenerLibreriaFees() {

		try {
			this.setIdContrato((Long) this.getSession().get("idContrato"));
			feesLibreriaDTO = feesTransaccioBO.obtenerLibreriaFees(this.getIdContrato());
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return Action.SUCCESS;
	}

	public String obtenerEstFees() {

		try {
			this.setIdContrato((Long) this.getSession().get("idContrato"));
			feesEstDTO = feesTransaccioBO.obtenerEstFees(this.getIdContrato());
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return Action.SUCCESS;
	}

	public String obtenerFees() {

		this.setIdContrato((Long) this.getSession().get("idContrato"));
		fees = feesTransaccioBO.obtenerFees(this.getIdContrato());
		return Action.SUCCESS;
	}

	public String guardarFees() {

		try {
			logger.debug("" + idCto + ":" + tipoCambio);
			this.setIdContrato(idCto);
			feesTransaccioBO.guardarFees(this.tipoFees, this.getIdContrato(), this.tipoCambio, this.feesPremierDTO,
					this.feesLibreriaDTO, this.feesEstDTO);

		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return Action.SUCCESS;
	}

	public String verificarCategMin() {

		try {
			boolean valido = feesTransaccioBO.verificarCategoria(this.idCategMin);
			this.fees = new FeesTransaccionDTO();
			this.fees.setValido(valido);

		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return Action.SUCCESS;
	}

	public String getError() {
		return error;
	}

	public FeesPremierDTO getFeesPremierDTO() {
		return feesPremierDTO;
	}

	public FeesLibreriaDTO getFeesLibreriaDTO() {
		return feesLibreriaDTO;
	}

	public FeesEstDTO getFeesEstDTO() {
		return feesEstDTO;
	}

	public FeesTransaccionDTO getFees() {
		return fees;
	}

	public String getTipoFees() {
		return tipoFees;
	}

	public void setError(String error) {
		this.error = error;
	}

	public void setFeesPremierDTO(FeesPremierDTO feesPremierDTO) {
		this.feesPremierDTO = feesPremierDTO;
	}

	public void setFeesLibreriaDTO(FeesLibreriaDTO feesLibreriaDTO) {
		this.feesLibreriaDTO = feesLibreriaDTO;
	}

	public void setFees(FeesTransaccionDTO fees) {
		this.fees = fees;
	}

	public void setFeesEstDTO(FeesEstDTO feesEstDTO) {
		this.feesEstDTO = feesEstDTO;
	}

	public void setTipoFees(String tipoFees) {
		this.tipoFees = tipoFees;
	}

	public void setIdCategMin(Long idCategMin) {
		this.idCategMin = idCategMin;
	}

	public void setIdCto(Long idCto) {
		this.idCto = idCto;
	}

	public void setTipoCambio(Long tipoCambio) {
		this.tipoCambio = tipoCambio;
	}

}