package com.mx.dla.dda.reporte.pago.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReportePagoBO;
import com.mx.dla.dda.reporte.pago.dtos.DetalleContratoDTO;

public class DetalleContratoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idEstudio;
	private List<DetalleContratoDTO> detalleContratos;

	@Autowired
	private ReportePagoBO reportePagoBO;

	public String execute() {
		setDetalleContratos(reportePagoBO.obtenerDetalleContratoPorEstudio(idEstudio));
		return SUCCESS;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public List<DetalleContratoDTO> getDetalleContratos() {
		return detalleContratos;
	}

	public void setDetalleContratos(List<DetalleContratoDTO> detalleContratos) {
		this.detalleContratos = detalleContratos;
	}

}
