package com.mx.dla.dda.reporte.pago.actions;

import java.io.InputStream;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReportePagoBO;

public class ReportePagoExcelAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private Long idCon;
	private Long idEstudio;
	private Date fechaInicio;

	@Autowired
	private ReportePagoBO reportePagoBO;

	public String execute() {
		fileInputStream = reportePagoBO.obtenerReporteEnExcel(fechaInicio, idCon, idEstudio);
		setFileName( idCon != null ? idEstudio + "_" + idCon : idEstudio + "");
		return SUCCESS;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Long getIdCon() {
		return idCon;
	}

	public void setIdCon(Long idCon) {
		this.idCon = idCon;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public Date getFechaInicio() {
		return fechaInicio;
	}

}
