$(document).ready(function(){
	    inicializarBotones();
		cargarApartados("todos");	
});

function inicializarBotones(){
	$("#buscar").click(function()   
	{					
		cargarApartados($("#selectTipoAmortizable").val());	
	});
	
	$("#btNuevoApartado").click(function()   
	{		     	  			
		var menu = $("#pmn").val();
		var menuRegreso = $("#pmnReturn").val();	
		window.location.href = contextPath + '/catalogos/bolsas/altaApartado.action?pmn='+menu+'&pmnReturn='+menuRegreso+ '&idApartado=' + null;
	});		
}

function cargarApartados(operacion){	
	$.post( contextPath + '/catalogos/bolsas/indexCatalogoApartados.action', {amortizable : operacion})		
	.done(function( response ) 
	{		
		if(response.mensaje != null)	
			showError("Error al procesar la operaci\u00F3n.");			      
		else
		{			
			limpiarTabla();
		    crearTablaApartados(response.apartados);
		    $("table thead tr").addClass("encabezado");
		}				   			       		   
	});	
}

function crearTablaApartados(datos) {	
	var data = [];		
	for(var i = 0; i < datos.length; i++) {
		var raw = [];
		raw.push(datos[i].descripcion);
		raw.push(datos[i].amortizable);
		raw.push(datos[i].idSap ? datos[i].idSap : "");  // Ajuste en la verificación de null
		raw.push(datos[i].idApartado);
		data.push(raw);
	}		
	
	var table = $('#cataApartados').DataTable({
		data: data,
		columns: [
			{ title: "Apartado" },	         
			{ title: "Tipo Amortizable" },
			{ title: "C&oacute;digo SAP" }	         	        
		],        
		"rowCallback": function (row, data, index) {	    			    		
			// Se agrega el link para ver el apartado
			var urlAction = contextPath + '/catalogos/bolsas/altaApartado.action?pmn=44' +                                                                             
							'&idApartado=' + datos[index].idApartado +
							'&descripcion=' + data[0] +
							'&amortizable=' + data[1] +
							'&idSAP=' + data[2];
			var html = '<a href="' + urlAction + '">' + data[0] + '</a>';
			$('td', row).eq(0).empty().append(html);						  							
		},	             
		language: {
			processing: "Procesando...",
			lengthMenu: "Mostrar _MENU_ registros",
			zeroRecords: "No se encontraron resultados",
			emptyTable: "No hay contratos que satisfagan los criterios de búsqueda.",
			info: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
			infoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
			infoFiltered: "(filtrado de un total de _MAX_ registros)",
			search: "Buscar:",
			thousands: ",",
			loadingRecords: "Cargando...",
			paginate: {
				first: "Primero",
				last: "&Uacute;ltimo",
				next: "Siguiente",
				previous: "Anterior"
			},
			aria: {
				sortAscending: ": Activar para ordenar la columna de manera ascendente",
				sortDescending: ": Activar para ordenar la columna de manera descendente"
			}
		},
		columnDefs: [],
		filter: true,
		info: false,
		ordering: false,
		scrollX: false,
		paging: true,
		pagingType: "full_numbers",
		order: []
	});			
}
	

function limpiarTabla(){
	$("#divApartados").empty();
	$("#cataApartados").remove();
	var table = $("<table class='table table-striped'/>").attr('id',"cataApartados");       
	$("#divApartados").append(table);	
}