function limpiarTabla(){		
	$('#catalogoPais').remove();				
	var table = $("<table class='table table-striped'/>").attr('id',"catalogoPais");       
	$("#contTabla").append(table);		
}

function realizaConsulta(){				
    // Obtener numero de menú
    var menu = $("#pmn").val();
    var menuRegreso = $("#pmnReturn").val();
    var namespace = "/catalogos/paises/index";
    
    var rowId = null;
    var oTable = null;
    
    oTable = $('#catalogoPais').DataTable({		    
        autoWidth: false,
        language: {	
            processing: "Procesando...",
            lengthMenu: "Mostrar _MENU_ registros",
            zeroRecords: "Sin eventos encontrados",
            emptyTable: "Sin eventos encontrados",
            info: "Mostrando _START_ al _END_ de _TOTAL_",
            infoEmpty: "0 registros",
            infoFiltered: "(filtrado de un total de _MAX_ registros)",
            search: "Buscar:",
            thousands: ",",
            loadingRecords: "Cargando...",
            paginate: {
                first: "Primero",
                last: "&Uacute;ltimo",
                next: "Siguiente",
                previous: "Anterior"
            }
        },
        pageLength: 10,
        info: false,
        filter: true,
        ordering: false,
        paging: true,
        pagingType: "full_numbers",
        order: [],
        ajax: {
            url: "indexlistadoPais",
            dataSrc: ""
        },
        columns: [
            { title: "Nombre", data: "nombre", searchable: true, width: "40px" },
            { title: "Territorio", data: "territorio", searchable: true, width: "90px" },
            { title: "Regi\u00F3n", data: "region", searchable: true, width: "60px" },
            { title: "Impuesto %", data: "impuesto", searchable: true, width: "40px" }
        ],          			 
        rowCallback: function(row, data, index) {
            var urlModificar = "<a href='" + contextPath + namespace +
                               "buscaPais.action?pmn=" + menu + "&pmnReturn=" + menuRegreso + "&pais.id=" + data["id"] + "'>" + data["nombre"] + "</a>";
            $(row).attr("id", data["id"]);
            $('td:eq(0)', row).html(urlModificar);
            $('td:eq(1)', row).html(data["territorio"]);
            $('td:eq(2)', row).html(data["region"]);
            $('td:eq(3)', row).html(data["impuesto"]);
        }
    });
}


function regreso(){	
	var menu = $("#pmnReturn").val();
	window.location.href = contextPath + "/catalogos/paises/index.action?pmn=" + menu;
}

function botonesAgregar(){
	$("#nuevo").click(function()  
	{
		var menu = $("#pmn").val();
		var menuRegreso = $("#pmnReturn").val();	
		window.location.href = contextPath + "/catalogos/paises/indexirCrearPais.action?pmn="+menu+"&pmnReturn="+menuRegreso;				
	});
}

function validar(){
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	"pais.nombre": 
			        {
			            required: true,
			            maxlength: 25,
			            regex:"^[A-Z. a-z\u00A0\u00E1\u00E9\u00ED\u00F3\u00FA\u00C1\u00C9\u00CD\u00D3\u00DA\u00D1\u00F1]+$"
			        },
		      		"pais.impuesto":
		      		{
		      			number: true,
		      			range:[1, 50]
		      		},
		      		"pais.idTerritorio": 
		      		{ 
		      			valueNotEquals: "", 
		      		},
		      		"pais.idRegion": 
		      		{ 
		      			valueNotEquals: "", 
		      		},
		      		"pais.estatus": 
		      		{ 
		      			valueNotEquals: "", 
		      		}
		        },
		        messages: 
		        {
		        	"pais.nombre": 
			         {
			            required: "Nombre del Pa&#237;s es obligatorio.",
			            maxlength: "Nombre no debe exceder 50 caracteres",
			            regex: "Nombre debe ser con caracteres alfab&#233;ticos"
			         },		          
		            "pais.impuesto": 
		             {
			            range: "Impuesto no debe ser mayor a 50"	
		             },
		             "pais.idTerritorio": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Territorio." 
		             },
		             "pais.idRegion": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Regi&#243;n." 
		             },
		             "pais.estatus": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Estatus." 
		             }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
		  var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
	
	$.validator.addMethod("valueNotEquals", function(value, element, arg){
		  return arg != value;
	}, "Value must not equal arg.");
}