function callActionAjax(actionRoute, jsonActionParameter, functionProcessor) {

    $.ajax({
        url: contextPath + actionRoute,
        type: 'POST',
        data: jsonActionParameter,
        dataType: "json",
        success: function(response) {
            functionProcessor(response);
        },
        error: function(jqXhr, textStatus, errorThrown) {

            alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
        }
    });

}

function cargaTablaMinimosSeleccion() {

    var idContrato = $('#idContrato').val();

    var jsonString = '{"idContrato" : ' + idContrato + '}';

    var stringJson = JSON.parse(jsonString);
    callActionAjax("/contrato/minimoSeleccion/cargaMinimosSeleccionData", stringJson, generaTablaMinimosSeleccion);

}

function placeholderFunction(data) {}

var idsCategorias = [];

function generaTablaMinimosSeleccion(jsonData) {
	
	if(jsonData.mensajeExcepcion != null){
		showWarn(jsonData.mensajeExcepcion);
	}

    var idNombreTablaContenedor = "divTabla";
    var idNombreTabla = "minimosSeleccionTabla";

    var periodos = jsonData.periodos;
    var annios = jsonData.annios;
    var categorias = jsonData.categorias;
    var anniosPeriodo = jsonData.anniosPeriodo;


    var periodosTamanio = periodos.length;
    var categoriasTamanio = categorias.length;

    var anniosTamanio = null;

    if (annios !== null)
        anniosTamanio = annios.length;

    var costosFlatTamanio = jsonData.costosFlat.length;
    var minimosSeleccionTamanio = jsonData.minimosSeleccion.length;

    var costosFlat = jsonData.costosFlat;
    var costosSuscriptores = jsonData.costosSuscriptores;
    var minimosSeleccion = jsonData.minimosSeleccion;
    
    var montosReal = jsonData.montosReales;


    $('#' + idNombreTabla).remove();

    if (periodos != null && periodos.length != 0 && categorias != null && categorias.length != 0) {

        var tabla =
            '<table id="' + idNombreTabla + '" class="fht-table">' +

            '<thead class="TitulosTabla">' +
            obtenFilaPeriodos_alt(periodos, annios, anniosPeriodo);

        tabla = tabla + obtenFilaTotalCategorias(annios, periodos, anniosPeriodo) +

            obtenFilaHeaderCategorias_alt(periodos, annios, anniosPeriodo) +
            '</thead>' +

            '<tbody class="ContenidoTabla">' +
            '</tbody>' +
            '</table>';

        $('#' + idNombreTablaContenedor).append(tabla);

        

        for (var l = 0; l < categoriasTamanio; l++) {
        	idsCategorias[l] = categorias[l].idPagoCateg;
            var detalle = obtenFilaDetalleCategorias_alt(periodos, annios, categorias[l], anniosPeriodo);

            $('#' + idNombreTabla + ' > tbody:last').append(detalle);
        }

        $('#' + idNombreTabla + ' > tbody:last').append(obtenFilaSinCategoria_alt(periodos, annios, anniosPeriodo));// se agrega un último renglon que representa a la suma de los titulos que no tengan categoria
        $('#' + idNombreTabla + ' > tbody:last').append(obtenFilaFooterCategorias_alt(periodos, annios, anniosPeriodo));//donde se va contruir el footer de total
        
        if (annios === null || annios !== null && anniosTamanio === 0)
            cargaCostosSuscriptores(costosSuscriptores);
        else
            cargaCostosFlat(costosFlat);

        cargaMontoReal(montosReal);
        calculaMinimosSeleccion(minimosSeleccion);

        var regex = '(t|mm)-p[0-9]+(-a[0-9]+)*(-c[0-9]+)*';
    	


        $("#guardarBoton").click(
            function() {
                guardaMinimosSeleccion();
            });

        
        $("#minimosSeleccionTabla").CongelarFilaColumna();

        generaEventosMinimos(regex);
        
        var estatusContrato = $("#estatusContrato").val(); 
		if (estatusContrato != 1){
			$("#formaId :input").attr("disabled", true);
			$("#formaId :input").css('background-color', '#DDDDDD');
		}
		
		validacionInicial(regex);


    } else {


        var mensajeVacio = '<div class="panel panel-custom-dla" >';
        mensajeVacio = mensajeVacio + '<div class="panel-heading"></div>';
        mensajeVacio = mensajeVacio + '<div class="panel-body text-center" >No hay informaci&oacute;n para mostrar</div>';
        mensajeVacio = mensajeVacio + '</div>';

        $('#divTabla').append(mensajeVacio);

    }

}


function validaNuloUndefinido(variable) {

    if ((variable === null && typeof variable === "object") ||
        (variable === undefined && typeof variable === "undefined") ||
        (variable === "" && typeof variable === "string")
    ) {
        return 0;
    } else {
        return variable;
    }
}

function noEditable(evt) {

    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode === 38 || charCode === 40 || charCode === 37 || charCode === 39)
        return true;
    return false;
}


function obtenFilaPeriodos(periodos, periodosColSpan) {

    var periodosTamanio = periodos.length;

    var detalle =
        '<tr>' +
        '<th>&nbsp;</th>';

    for (var i = 0; i < periodosTamanio; i++)
        detalle = detalle + '<th  colspan="' + periodosColSpan + '">' + periodos[i].fechaInicio + ' al ' + periodos[i].fechaFin + '</th>';

    detalle = detalle + '</tr>';

    return detalle;
}

function validaPermisos(pmn){
	var perfilService = new PerfilService();
	var data = perfilService.obtenerPermisos(pmn);
	if(data.permisoSi === 0){
		showError("No se tienen permisos para realizar esta acci&oacute;n.");
		return false;
	} else {
		return true;
	}
}

function obtenFilaPeriodos_alt(periodos, annios, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var periodosNumColumnas = periodosTamanio;
    var anniosPeriodoTamanio = anniosPeriodo.length;
    var anniosTamanio = null;
    var categoriasColTamanio = 5; //eran 3 como se anexo monto real y los indicadores de paloma y tache se agregan 2

    var detalle =
        '<tr>' +
        '<th style="background-color: #cb2c25; width:300px; color: #ffffff;"></th>';

    for (var i = 0; i < periodosTamanio; i++) {

        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0))
            anniosTamanio = 1;
        else {

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }


        var categoriasNumColumnas = periodosTamanio * anniosTamanio * categoriasColTamanio;
        var periodosColSpan = categoriasNumColumnas / periodosNumColumnas;

        detalle = detalle + '<th class="text-center" style="width:450px;" colspan="' + periodosColSpan + '">' + periodos[i].fechaInicio + ' al ' + periodos[i].fechaFin + '</th>';
    }

    detalle = detalle + '</tr>';

    return detalle;
}

function obtenFilaAnios(annios, periodos, anniosColSpan) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = annios.length;

    var detalle =
        '<tr>' +
        '<th>&nbsp;</th>';

    for (var i = 0; i < periodosTamanio; i++)
        for (var j = 0; j < anniosTamanio; j++)
            detalle = detalle + '<th colspan="' + anniosColSpan + '">' + 'A&ntildeo ' + annios[j].annio + '</th>';

    detalle = detalle + '</tr>';

    return detalle;
}

function obtenFilaAnios_alt(annios, periodos, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosPeriodoTamanio = anniosPeriodo.length;
    var categoriasColTamanio = 3;

    var detalle = '<tr>' + '<th style="background-color: #cb2c25; color: #ffffff;">&nbsp;</th>';

    for (var i = 0; i < periodosTamanio; i++) {
        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0))
            anniosTamanio = 1;
        else {

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        var anniosNumColumnas = periodosTamanio * anniosTamanio;
        var categoriasNumColumnas = periodosTamanio * anniosTamanio * categoriasColTamanio;

        var anniosColSpan = categoriasNumColumnas / anniosNumColumnas;
        for (var j = 0; j < anniosTamanio; j++)
            detalle = detalle + '<th class="text-center" colspan="' + anniosColSpan + '" style="border-right: 1px solid #dddddd;">' + 'A&ntildeo ' + annios[j].annio + '</th>';

    }

    detalle = detalle + '</tr>';

    return detalle;
}


function obtenFilaTotalCategorias(annios, periodos, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosExisten = null;

    var anniosPeriodoTamanio = anniosPeriodo.length;
    var categoriasColTamanio = 4;


    var detalle = '<tr>' + '<th style="background-color: #cb2c25; color: #ffffff;"></th>';

    for (var i = 0; i < periodosTamanio; i++) {
        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0)) {
            anniosTamanio = 1;
            anniosExisten = false;
        } else {
            anniosExisten = true;

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        var anniosNumColumnas = periodosTamanio * anniosTamanio;
        var categoriasNumColumnas = periodosTamanio * anniosTamanio * categoriasColTamanio;

        var anniosColSpan = categoriasNumColumnas / anniosNumColumnas;

        for (var j = 0; j < anniosTamanio; j++) {

            detalle = detalle + '<th colspan="' + anniosColSpan + '" style="border-left: 1px solid #dddddd;"> <div class="form-group"><div class="col-xs-1"></div><div class="col-xs-4">M\u00EDnimo [$]:</div>' +
                '<div class="col-xs-6"><input style="background-color: #FFFFFF; " id="mm-p' + periodos[i].idContratoPago;
            
            if (anniosExisten === true) detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '" type="text" class="form-control text-right"  value="0.00"></input></div><div class="col-xs-1"></div></div></th>';


        }
        //se agrego para colocar la columna xv(tache-paloma)
        detalle = detalle + '<th style="border-left: 1px solid #dddddd;"><div id="mm-p'+ idPeriodo +'-xv" class="text-center divXV glyphicon glyphicon-remove"> </div></th>';
        
    }

    detalle = detalle + '</tr>';

    return detalle;
}

function obtenFilaHeaderCategorias(periodos, annios) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;

    if (annios === null)
        anniosTamanio = 0;
    else
        anniosTamanio = annios.length;

    var anniosTamanioFinal = anniosTamanio;

    if (anniosTamanio === 0)
        anniosTamanioFinal = 1;

    var detalle =
        '<tr>' +
        '<th>' + '</th>';

    for (var i = 0; i < periodosTamanio; i++)
        for (var j = 0; j < anniosTamanioFinal; j++) {
            detalle = detalle + '<th>' + '<div class="text-center">T\u00EDtulos</div>' + '</th>';
            detalle = detalle + '<th>' + '<div class="text-center">Precio Anual</div>' + '</th>';
            detalle = detalle + '<th >' + '<div class="text-center">M\u00EDnimo</div>' + '</th>';
        }

    detalle = detalle + '</tr>';

    return detalle;
}


function obtenFilaHeaderCategorias_alt(periodos, annios, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosPeriodoTamanio = anniosPeriodo.length;

    var detalle = '<tr>' + '<th style="background-color: #cb2c25; color: #ffffff;"><div>Categor\u00EDas' + '</div></th>';
    for (var i = 0; i < periodosTamanio; i++) {


        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0))
            anniosTamanio = 1;
        else {

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        for (var j = 0; j < anniosTamanio; j++) {
            detalle = detalle + '<th>' + '<div class="text-center">T\u00EDtulos</div>' + '</th>';
            detalle = detalle + '<th>' + '<div class="text-center">Precio</div>' + '</th>';
            detalle = detalle + '<th>' + '<div class="text-center">Monto Real</div>' + '</th>';//se agrego para tener la columna de monto real
            detalle = detalle + '<th  style="border-right: 1px solid #dddddd;">' + '<div class="text-center">M\u00EDnimo</div>' + '</th>';
            detalle = detalle + '<th  style="border-right: 1px solid #dddddd;">' + '<div class="text-center"></div>' + '</th>';//Se agrego para tener la columna de xv(tache-paloma)
        }

    }

    detalle = detalle + '</tr>';

    return detalle;
}


function obtenFilaDetalleCategorias(periodos, annios, categoria) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;

    if (annios === null)
        anniosTamanio = 0;
    else
        anniosTamanio = annios.length;

    var anniosTamanioFinal = anniosTamanio;

    if (anniosTamanio === 0)
        anniosTamanioFinal = 1;

    var detalle =
        '<tr>' +
        '<td style="font-size: 0.875em;">' + categoria.descCategoria + '</td>';

    for (var i = 0; i < periodosTamanio; i++)
        for (var j = 0; j < anniosTamanioFinal; j++) {

            detalle = detalle + '<td class ="">' + '<input id="t-p' + periodos[i].idContratoPago;

            if (anniosTamanio !== 0)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" type="text" class="form-control text-right"></input>' + '</td>';

            detalle = detalle + '<td class =" ">' + '<div id="n-p' + periodos[i].idContratoPago;

            if (anniosTamanio !== 0)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" ></div>' + '</td>';

            detalle = detalle + '<td class =" ">' + '<div id="m-p' + periodos[i].idContratoPago;

            if (anniosTamanio !== 0)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" ></div>' + '</td>';

        }


    detalle = detalle + '</tr>';

    return detalle;
}


function obtenFilaDetalleCategorias_alt(periodos, annios, categoria,
    anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosExisten = null;
    var anniosPeriodoTamanio = anniosPeriodo.length;

    var detalle = '<tr>' + '<td style="border-bottom: 1px solid #ffffff;"><input value="' + categoria.descCategoria + '" type="text" class="form-control divStyle" onkeydown="return noEditable(event);"></input></td>';

    for (var i = 0; i < periodosTamanio; i++) {

        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0)) {
            anniosTamanio = 1;
            anniosExisten = false;
        } else {

            anniosExisten = true;

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        for (var j = 0; j < anniosTamanio; j++) {
        	
        	//para columna titulos
            detalle = detalle + '<td>' + '<input id="t-p' + periodos[i].idContratoPago;

            if (anniosExisten === true)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" type="text" class="form-control text-right" value="0"></input>' + '</td>';
            
            //para columna precio
            detalle = detalle + '<td>' + '<input id="n-p' + periodos[i].idContratoPago;

            if (anniosExisten === true)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" type="text" class="form-control text-right"  value="0.00" readonly></input>' + '</td>';
            
            //se agrego para para columna monto real
            detalle = detalle + '<td>' + '<input id="mr-p' + periodos[i].idContratoPago+ '-c' + categoria.idPagoCateg + '" type="text" class="form-control text-right"  value="0.00" readonly></input>' + '</td>';
            
            //para columna minimo
            detalle = detalle + '<td  style="border-right: 1px solid #dddddd;">' + '<input id="m-p' + periodos[i].idContratoPago;

            if (anniosExisten === true)
                detalle = detalle + '-a' + annios[j].annio;

            detalle = detalle + '-c' + categoria.idPagoCateg + '" type="text" class="form-control text-right"  value="0.00" readonly></input>' + '</td>';
            
            //se agrego para columna de xv(tache-paloma) 
            detalle = detalle + '<td class =" "> <div id="xv-p' + periodos[i].idContratoPago + '-c' + categoria.idPagoCateg + '" class="text-center divXV glyphicon glyphicon-remove"></div> </td>';
        }

    }

    detalle = detalle + '</tr>';

    return detalle;
}


function cargaCostosFlat(costosFlat) {

    var costosFlatTamanio = costosFlat.length;


    for (var i = 0; i < costosFlatTamanio; i++) {

        var costo = costosFlat[i].costo;

        if (costo === null)
            costo = "0";

        $("#n-p" + costosFlat[i].idContratoPago + "-a" + costosFlat[i].annio + "-c" + costosFlat[i].idPagoCateg).val(formatCurrency(Number(unformatCurrency(costo)), 2));
    }

}

function cargaCostosSuscriptores(costosSuscriptores) {

    var costosSuscriptoresTamanio = costosSuscriptores.length;


    for (var i = 0; i < costosSuscriptoresTamanio; i++) {

        var costo = costosSuscriptores[i].costo;

        if (costo === null)
            costo = "0";


        $("#n-p" + costosSuscriptores[i].idContratoPago + "-c" + costosSuscriptores[i].idPagoCateg).val(formatCurrency(Number(unformatCurrency(costo)), 2));
    }

}

function calculaMinimosSeleccion(minimosSeleccion) {

    var minimosSeleccionTamanio = minimosSeleccion.length;

    for (var i = 0; i < minimosSeleccionTamanio; i++) {

        var idPagoCategoria = minimosSeleccion[i].idPagoCategoria;
        var minimoSeleccion = minimosSeleccion[i].minimoSeleccion;
        var annio = minimosSeleccion[i].annio;

        var selectorBase = "-p" + minimosSeleccion[i].idContratoPago;

        if (annio !== null)
            selectorBase = selectorBase + "-a" + minimosSeleccion[i].annio;

        if (idPagoCategoria !== null)
            selectorBase = selectorBase + "-c" + minimosSeleccion[i].idPagoCategoria;

        var costo = $("#n" + selectorBase).val();

        var minimoSeleccionFormateado = "";

        if (idPagoCategoria === null) {

            if (minimoSeleccion !== null)
                minimoSeleccionFormateado = formatCurrency(Number(unformatCurrency(minimoSeleccion)), 2);

            $("#mm" + selectorBase).val(minimoSeleccionFormateado);

        } else {

            if (minimoSeleccion !== null)
                minimoSeleccionFormateado = formatCurrency(Number(unformatCurrency(minimoSeleccion)));

            $("#t" + selectorBase).val(minimoSeleccionFormateado);

            if (minimoSeleccion === null)
                minimoSeleccion = "0";

            $("#m" + selectorBase).val(formatCurrency(unformatCurrency(minimoSeleccion) * unformatCurrency(costo), 2));
        }

    }

}

function generaEventosMinimos(regex) {

    $('input[type=text]').filter(function() {
        return this.id.match(new RegExp(regex));
    }).each(function(i, obj) {

        var idInput = obj.id;

        $('#' + idInput).change(function() {
            $('#' + idInput).addClass("haCambiado");
        });

        $('#' + idInput).focus(function() {
            $('#' + idInput).data('oldVal', $('#' + idInput).val());
        });

        $('#' + idInput).blur(function() {
            var titulo = myTrim($('#' + idInput).val());
            var oldValue = $('#' + idInput).data('oldVal');

            if (idInput.indexOf("t-") !== -1) {

                if (validaCifraTitulos(titulo)) {
                    validaActualiza(idInput, idsCategorias);
                } else {

                    var oldValueFormateado = "";

                    if (oldValue !== "")
                        oldValueFormateado = formatCurrency(Number(unformatCurrency(oldValue)));


                    $('#' + idInput).val(oldValueFormateado);

                    showError("No se ha proporcionado una cantidad v\u00E1lida");

                }
            }



            if (idInput.indexOf("mm-") !== -1) {

                if (validateCifraTotalMinimos(titulo)) {

                    var minimoSeleccionFormateado = "";

                    if (titulo !== "")
                        minimoSeleccionFormateado = formatCurrency(Number(unformatCurrency(titulo)), 2);

                    $('#' + idInput).val(minimoSeleccionFormateado);
                    validaMinimo(idInput);
                } else {

                    var oldValueFormateado = "";

                    if (oldValue !== "")
                        oldValueFormateado = formatCurrency(Number(unformatCurrency(oldValue)));


                    $('#' + idInput).val(oldValueFormateado);
                    

                    showError("No se ha proporcionado una cantidad valida");
                }
            }

        });

    });

}

function remueveMarcadosGuardar(data) {

    $('.haCambiado').each(function(i, obj) {

        var idInput = obj.id;
        $('#' + idInput).removeClass("haCambiado");

    });


    var menu = $("#pmn").val();
    var menuRegreso = $("#pmnReturn").val();
    guardadoStatus = data.guardadoStatus;
    window.location.href = contextPath + "/contrato/minimoSeleccion/index.action?pmn=" + menu + "&pmnReturn=" + menuRegreso + "&guardadoStatus=" + guardadoStatus;

}



function guardaMinimosSeleccion() {

    var jsonString = '';
    var item = 0;
    var validaParcialMayor = false;


    var idContrato = $('#idContrato').val();
    var justificacion = $('#justificacion').val();

    jsonString = jsonString + '{"idContrato" :' + idContrato;


    if (validaNuloUndefinido(justificacion) !== 0)
        jsonString = jsonString + ', "justificacion" : "' + justificacion + '"';

    jsonString = jsonString + ',';


    $('.haCambiado').each(function(i, obj) {

        var idInput = obj.id;
        var idContratoPago = obtenNSplitPorSeparador(obtenNSplitPorSeparador(idInput, "-", 1), "p", 1);
        var annio = null;
        var idPagoCategoria = null;

        var annioId = obtenNSplitPorSeparador(idInput, "-a", 1);

        if (validaNuloUndefinido(annioId) === 0) {

            splittedString = obtenNSplitPorSeparador(idInput, "-", 2);
            if (validaNuloUndefinido(splittedString) !== 0)
                idPagoCategoria = obtenNSplitPorSeparador(splittedString, "c", 1);

        } else {
            annio = obtenNSplitPorSeparador(obtenNSplitPorSeparador(idInput, "-", 2), "a", 1);

            splittedString = obtenNSplitPorSeparador(idInput, "-", 3);
            if (validaNuloUndefinido(splittedString) !== 0)
                idPagoCategoria = obtenNSplitPorSeparador(splittedString, "c", 1);
        }

        var evaluacion = evaluaSumaNoTitulos(idContratoPago, annio);


        var minimoSeleccion = $('#' + idInput).val();

        var valorGuardar = null;

        if (minimoSeleccion !== "")
            valorGuardar = Number(unformatCurrency(minimoSeleccion));

        if (evaluacion === true)
            validaParcialMayor = true;


        jsonString = jsonString + '"minimosSeleccion[' + i + '].idContratoPago":' + idContratoPago + ',"minimosSeleccion[' + i + '].idPagoCategoria":' + idPagoCategoria + ',"minimosSeleccion[' + i + '].annio":' + annio + ',"minimosSeleccion[' + i + '].minimoSeleccion":' + valorGuardar + ',';

        item = item + 1;
    });


    jsonString = jsonString.substr(0, jsonString.length - 1) + '}';


    if (validaParcialMayor === true)
        showError("La suma de los m\u00EDnimos parciales es mayor a la del m\u00EDnimo total definido");
    else if (item !== 0) {

        var stringJson = JSON.parse(jsonString);
        callActionAjax("/contrato/minimoSeleccion/guardaMinimosSeleccionData", stringJson, remueveMarcadosGuardar);

    }


}


function evaluaSumaNoTitulos(titulo, annio) {

    var regexSumatoriaMinimos = null;
    var regexTotalesMinimos = null;


    if (annio === null) {
        regexSumatoriaMinimos = 'm-p' + titulo + '-c[0-9]+';
        regexTotalesMinimos = 'mm-p' + titulo;

    } else {
        regexSumatoriaMinimos = 'm-p' + titulo + '-a' + annio + '-c[0-9]+';
        regexTotalesMinimos = 'mm-p' + titulo + '-a' + annio;
    }

    var minimoTotalValor = $('#' + regexTotalesMinimos).val();
    if (minimoTotalValor !== "" && Number(unformatCurrency(minimoTotalValor)) !== 0) {

        var minimoTotal = Number(unformatCurrency(minimoTotalValor));
        var minimoSumatoria = 0;


        $('input[type=text]').filter(function() {
            return this.id.match(new RegExp(regexSumatoriaMinimos));
        }).each(function(i, obj) {

            var idInput = obj.id;

            var minimoParcial = $('#' + idInput).val();

            minimoSumatoria = minimoSumatoria + Number(unformatCurrency(minimoParcial));

        });


        if (minimoSumatoria > minimoTotal)
            return true;

        return false;

    } else return false;

}

function obtenNSplitPorSeparador(cadena, separador, nOcurrencia) {
    var ocurrencias = cadena.split(separador);
    return ocurrencias[nOcurrencia];
}


/***********************************************************************/
function cargaMontoReal(montosReales) {	

    var montosRealesTamanio = montosReales.length;


    for (var i = 0; i < montosRealesTamanio; i++) {

        var monto = montosReales[i].monto;

        if (monto === null)
        	monto = "0";



        $("#mr-p" + montosReales[i].idPeriodo +  "-c" + montosReales[i].idCategoria).val(formatCurrency(Number(unformatCurrency(monto)), 2));
    }

}

function obtenFilaSinCategoria_alt(periodos, annios, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosPeriodoTamanio = anniosPeriodo.length;
    var detalle = '<tr>' + '<td style="border-bottom: 1px solid #ffffff;"><input value="Sin Categor&iacute;a" type="text" class="form-control divStyle"></input></td>';
    for (var i = 0; i < periodosTamanio; i++) {


        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0))
            anniosTamanio = 1;
        else {

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        for (var j = 0; j < anniosTamanio; j++) {
            detalle = detalle + '<td style="border-bottom: 1px solid #ffffff;">' + '<div class="text-right"></div>' + '</td>';
            detalle = detalle + '<td style="border-bottom: 1px solid #ffffff;">' + '<div class="text-right"></div>' + '</td>';
            detalle = detalle + '<td style="border-bottom: 1px solid #ffffff;">' + '<input id="mr-p' + idPeriodo + '-cSIN' + '" type="text" class="form-control text-right" value="0.00" readonly></input>'+ '</td>';
            detalle = detalle + '<td style="border-right: 1px solid #dddddd; border-bottom: 1px solid #ffffff;">' + '<div class="text-right"></div>' + '</td>';
            detalle = detalle + '<td style="border-bottom: 1px solid #ffffff;">' + '<div class="text-center"></div>' + '</td>';
        }

    }

    detalle = detalle + '</tr>';

    return detalle;
}


function obtenFilaFooterCategorias_alt(periodos, annios, anniosPeriodo) {

    var periodosTamanio = periodos.length;
    var anniosTamanio = null;
    var anniosPeriodoTamanio = anniosPeriodo.length;

    var detalle = '<tr>' + '<td style="background-color: #cb2c25; color: #ffffff;"><div>Total: ' + '</div></td>';
    for (var i = 0; i < periodosTamanio; i++) {


        var idPeriodo = periodos[i].idContratoPago;

        if (annios === null || (annios !== null && annios.length === 0))
            anniosTamanio = 1;
        else {

            for (var j = 0; j < anniosPeriodoTamanio; j++)
                if (anniosPeriodo[j].idContratoPago === idPeriodo)
                    break;

            anniosTamanio = anniosPeriodo[j].annio;
        }

        for (var j = 0; j < anniosTamanio; j++) {
            detalle = detalle + '<td style="background-color: #cb2c25; color: #ffffff;">' + '<div class="text-right"></div>' + '</td>';
            detalle = detalle + '<td style="background-color: #cb2c25; color: #ffffff;">' + '<div class="text-right"></div>' + '</td>';
            detalle = detalle + '<td style="background-color: #cb2c25; color: #ffffff;">' + '<input id="mr-p' + idPeriodo + '-cTOTAL' + '" type="text" class="form-control text-right" value="0.00" readonly></input>'+ '</td>';
            detalle = detalle + '<td style="border-right: 1px solid #dddddd; background-color: #cb2c25; color: #ffffff;">' + '<input id="m-p' + idPeriodo + '-cTOTALMIN' + '" type="text" class="form-control text-right" value="0.00" readonly></input>' + '</td>';
            detalle = detalle + '<td style="border-right: 1px solid #dddddd; background-color: #cb2c25; color: #ffffff;">' + '<div id="m-p'+ idPeriodo + '-xv' +'" class="text-center divXV glyphicon glyphicon-remove"></div>' + '</td>';
        }

    }

    detalle = detalle + '</tr>';

    return detalle;
}


function validaActualiza(idInput, idsCategorias) {
	
	var idSeparado = idInput.split("-");
	var mayorAtres = idSeparado.length > 3 ? true : false;
	
	var valorInput = 0.0;
	var sumatoria = 0.0;
	var totalMontoReal = 0.0;
	var minimoSeleccionVal;
	var minimoSeleccion = 0.0;
	var titulosVal;
	var precioVal;
	var minimoVal;
	var titulosPorPrecio = 0.0;
	var montoRealVal;
	
	//obtenemos los valores del periodo depenediendo del id formado
	if(mayorAtres) {
		minimoSeleccionVal = $('#mm-' + idSeparado[1]+ '-' + idSeparado[2] ).val();
		titulosVal = $('#t-' + idSeparado[1] + '-' + idSeparado[2] + '-' + idSeparado[3]).val();
		precioVal = $('#n-' + idSeparado[1] + '-' + idSeparado[2] + '-' + idSeparado[3]).val();
		minimoVal = $('#m-' + idSeparado[1] + '-' + idSeparado[2] + '-' + idSeparado[3]).val();
		montoRealVal = $('#mr-' + idSeparado[1] + '-' + idSeparado[3]).val();
	}else {
		minimoSeleccionVal = $('#mm-' + idSeparado[1]).val();
		titulosVal = $('#t-' + idSeparado[1] + '-' + idSeparado[2]).val();
		precioVal = $('#n-' + idSeparado[1] + '-' + idSeparado[2]).val();
		minimoVal = $('#m-' + idSeparado[1] + '-' + idSeparado[2]).val();
		montoRealVal = $('#mr-' + idSeparado[1] + '-' + idSeparado[2]).val();
	}
	
	//se verifica el numero de titulos, y se multiplica el numero de titulos por el precio
	
	if (titulosVal === "")
		titulosVal = "0";
	
	titulosPorPrecio = Number(unformatCurrency(titulosVal)) * Number(unformatCurrency(precioVal));
	
	var selector;
	
	//se coloca el valor del titulos por precio en el campo de minimo y se arma el selector dependiendo el id formada para colocar tache o paloma
	if(mayorAtres) {
		$('#m-' + idSeparado[1] + '-' + idSeparado[2] + '-' + idSeparado[3]).val(formatCurrency(titulosPorPrecio, 2));
		selector = '#xv-' + idSeparado[1] + '-' + idSeparado[3];
	}else {
		$('#m-' + idSeparado[1] + '-' + idSeparado[2]).val(formatCurrency(titulosPorPrecio, 2));
		selector = '#xv-' + idSeparado[1] + '-' + idSeparado[2];
	}
	
	//si el precio el mayor al monto real se indica tache en caso contrario paloma
	
	if(titulosPorPrecio > Number(unformatCurrency(montoRealVal))) {
		cambiaVX(selector);
	}else {
		cambiaXV(selector);
	}
	
	//se itera sobre la columna de minimo para obtner la suma total de minimos
	
	for(var i = 0; i < idsCategorias.length; i++) {
		
		if(idSeparado.length > 3) {
			valorInput = $('#m-' + idSeparado[1] + '-' + idSeparado[2] +'-c'+idsCategorias[i]).val();
		}else {
			valorInput = $('#m-' + idSeparado[1] + '-c'+idsCategorias[i]).val();
		}
		
		if(valorInput === null || valorInput === undefined)
			valorInput = 0.0;
		
		sumatoria += (Number(unformatCurrency(valorInput)));
	}
	
	if(minimoSeleccionVal === null || minimoSeleccionVal == undefined || minimoSeleccionVal === '')
		minimoSeleccionVal = '1,000,000,000,000';
	
	//se valida el minimo y la sumatoria de minimo para colocar tache o paloma
	cambiaClassXVMinimo(minimoSeleccionVal, formatCurrency(sumatoria, 2), idSeparado[1]);
		
	$('#m-' + idSeparado[1] + '-cTOTALMIN').val(formatCurrency(sumatoria, 2));
	 
}

function validaMinimo(idInput) {
	
	var idSeparado = idInput.split("-");
	var mayorAtres = idSeparado.length > 3 ? true : false;
	
	var sumaMinimoVal;
	var minimoVal;
	
	sumaMontoReal = $('#mr-'+ idSeparado[1] + '-cTOTAL' ).val();
	sumaMinimo = $('#m-'+ idSeparado[1] + '-cTOTALMIN' ).val();
	minimoVal = $('#' + idInput).val();
	
	
	
	var desicion ;
	
	if(minimoVal === null || minimoVal === undefined || minimoVal == '') {
		
		desicion = true;
		
	}else {
		desicion = (Number(unformatCurrency(minimoVal))) <=  (Number(unformatCurrency(sumaMontoReal))) ? true : false;
	}
	
	if(desicion){
		cambiaXV('#mm-'+ idSeparado[1] +'-xv');
	}else {
		cambiaVX('#mm-'+ idSeparado[1] +'-xv');
	}
	
	cambiaClassXVMinimo(minimoVal, sumaMinimo, idSeparado[1]);
	
}

function cambiaClassXVMinimo(minimo, sumatoriaMinimos, idPerido) {
	
	if(comparaMinimos(minimo, sumatoriaMinimos)){
		cambiaXV('#m-'+ idPerido + '-xv');
	}else {
		cambiaVX('#m-'+ idPerido + '-xv');
	}
}

function cambiaXV(selector) {
	$(selector).removeClass("glyphicon-remove");
	$(selector).addClass("glyphicon-ok");
}

function cambiaVX(selector) {
	$(selector).removeClass("glyphicon-ok");
	$(selector).addClass("glyphicon-remove");
}


function comparaMinimos(minimo, sumatoriaMinimos) {
	var respuesta = false;
	if(minimo === null || minimo === undefined || minimo == '') {
			respuesta = true;
	}else {
		
		if((Number(unformatCurrency(minimo))) >= (Number(unformatCurrency(sumatoriaMinimos)))){
			respuesta = true;
		}
	}
	return respuesta;
}

function validacionInicial(regex){
	 $('input[type=text]').filter(function() {
	        return this.id.match(new RegExp(regex));
	    }).each(function(i, obj) {
	    	
	    	var idInput = obj.id;
	    	
	    	if (idInput.indexOf("t-") !== -1) {
	    		validaActualiza(idInput, idsCategorias);
	    	}
	    	
	    	if (idInput.indexOf("mm-") !== -1) {
	    		validaMinimo(idInput);
	    	}
	    	
	    });
	
}


/***********************************************************************/



function despuesGuardadoFunction(data) {

    $(".edited").removeClass("edited");
    $(".dirty-cell").removeClass("dirty-cell");

    showMessage("La informaci&oacute;n se ha guardado con exito");
}

function obtenInformacionProceso(jsonData) {

    var periodos = jsonData.periodos;
    var annios = jsonData.annios;
    var anniosPeriodo = jsonData.anniosPeriodo;

    var categorias = jsonData.categorias;
    var costosFlat = jsonData.costosFlat;
    var costosSuscriptores = jsonData.costosSuscriptores;
    var minimosSeleccion = jsonData.minimosSeleccion;

    var periodosTamanio = periodos.length;
    var categoriasTamanio = categorias.length;

    var anniosTamanio = null;

    var periodosInfo = [];
    var aniosInfo = [];
    var categoriasInfo = [];

    var rubrosInfo = ["Titulos", "Precio Anual", "Minimo"];
    var idsRubrosInfo = ["t", "p", "m"];

    if (annios === null || annios !== null && annios.length == 0) {
        anniosTamanio = 1;
        annios = null;
    } else
        anniosTamanio = annios.length;

    if (periodos != null && periodos.length != 0 && categorias != null && categorias.length != 0) {

        var botonGuardar = '<button class="btn btn-success" id="guardarBoton" type="button">Guardar cambios</button>';
        var tablaGrid = '<table id="grid"></table>';

        $('#divTabla').append(tablaGrid);
        $('#divBoton').append(botonGuardar);

        var grid = $("#grid");

        for (var i = 0; i < periodosTamanio; i++)
            periodosInfo.push({
                index: i + 1,
                id: periodos[i].idContratoPago,
                desc: periodos[i].fechaInicio + " al " + periodos[i].fechaFin
            });

        if (annios !== null)
            for (var i = 0; i < anniosTamanio; i++)
                aniosInfo.push({
                    index: i + 1,
                    id: annios[i].annio,
                    desc: "A&ntildeo " + annios[i].annio
                });
        else
            aniosInfo = null;

        for (var i = 0; i < categoriasTamanio; i++)
            categoriasInfo.push({
                index: i,
                id: categorias[i].idPagoCateg,
                desc: categorias[i].descCategoria
            });

        var jsonData = [];

        jsonData = generaJsonEstructuraInicial(categorias, periodos, annios);

        jsonData = ejecutaCargaInformacion(jsonData, costosSuscriptores,
            costosFlat, minimosSeleccion, categoriasInfo, periodosInfo,
            aniosInfo);

        generaGridMinimos(grid, jsonData, categoriasInfo, periodosInfo,
            aniosInfo, rubrosInfo, idsRubrosInfo, anniosPeriodo);

        $("#guardarBoton").click(
            function() {

                var grid = $("#grid");

                ejecutaGuardadoModificados(grid, categoriasInfo,
                    periodosInfo, aniosInfo, rubrosInfo);

            });

    } else {

        var mensajeVacio = '<div class="panel panel-info">';
        mensajeVacio = mensajeVacio + '<div class="panel-heading"></div>';
        mensajeVacio = mensajeVacio + '<div class="panel-body text-center">No hay informaci&oacute;n para mostrar</div>';
        mensajeVacio = mensajeVacio + '</div>';

        $('#divTabla').append(mensajeVacio);
    }

}

function generaJsonEstructuraInicial(categorias, periodos, annios) {

    var categoriasTamanio = categorias.length;
    var periodosTamanio = periodos.length;
    var anniosTamanio = null;

    if (annios !== null)
        anniosTamanio = annios.length;
    else
        anniosTamanio = 1;

    var jsonData = [];

    for (var i = 0; i <= categoriasTamanio; i++) {

        var idGrupo = 0;
        var id = null;
        var desc = null;
        var tv = null;
        var pv = null;

        if (i === 0) {
            desc = '<h6><strong class="text-info">Minimo Total</strong></h6>';
        } else {
            id = i - 1;
            desc = categorias[id].descCategoria;
            tv = '0';
            pv = '0';
        }

        var item = {};
        item['id'] = id;
        item['descCategoria'] = desc;

        for (var j = 0; j < periodosTamanio; j++)
            for (var k = 0; k < anniosTamanio; k++) {

                item['t' + idGrupo] = tv;
                item['p' + idGrupo] = pv;
                item['m' + idGrupo] = '0';

                idGrupo = idGrupo + 1;
            }

        jsonData.push(item);

    }

    return jsonData;
}

function ejecutaCargaInformacion(jsonData, costosSuscriptores, costosFlat,
    minimosSeleccion, categoriasDefinicion, periodosDefinicion,
    aniosDefinicion) {

    var anniosTamanio = null;
    var periodosTamanio = periodosDefinicion.length;

    if (aniosDefinicion != null)
        anniosTamanio = aniosDefinicion.length;
    else
        anniosTamanio = 1;

    if (aniosDefinicion != null)
        jsonData = cargaJsonCostosFlatInformacion(costosFlat, jsonData,
            categoriasDefinicion, periodosDefinicion, aniosDefinicion);
    else
        jsonData = cargaJsonCostosSuscriptoresInformacion(costosSuscriptores,
            jsonData, categoriasDefinicion, periodosDefinicion,
            aniosDefinicion);

    jsonData = cargaJsonTitulosInformacion(minimosSeleccion, jsonData,
        categoriasDefinicion, periodosDefinicion, aniosDefinicion);

    jsonData = cargaJsonCalculoMinimosInformacion(jsonData, anniosTamanio * periodosTamanio);

    return jsonData;

}

function cargaJsonCostosSuscriptoresInformacion(costosSuscriptores, jsonData,
    categoriasDefinicion, periodosDefinicion, aniosDefinicion) {

    var costosSuscriptoresTamanio = costosSuscriptores.length;
    var anniosTamanio = null;

    for (var i = 0; i < costosSuscriptoresTamanio; i++) {
        var indexCategoria = obtenIndexPorParametroValor(categoriasDefinicion,
            "id", costosSuscriptores[i].idPagoCateg, "index");
        var indexPeriodo = obtenIndexPorParametroValor(periodosDefinicion,
            "id", costosSuscriptores[i].idContratoPago, "index");
        var indexAnio = null;

        var costo = costosSuscriptores[i].costo;
        var idGroup = null;

        if (aniosDefinicion !== null) {
            anniosTamanio = aniosDefinicion.length;
            indexAnio = obtenIndexPorParametroValor(aniosDefinicion, "id",
                costosSuscriptores[i].annio, "index");
            idGroup = (((indexPeriodo - 1) * anniosTamanio) + indexAnio) - 1;
        } else
            idGroup = indexPeriodo - 1;

        if (Number(idGroup) >= 0)
            actualizaJsonParametro(jsonData, "id", indexCategoria, "p" + idGroup, costo);

    }

    return jsonData;
}

function cargaJsonCostosFlatInformacion(costosFlat, jsonData,
    categoriasDefinicion, periodosDefinicion, aniosDefinicion) {

    var costosFlatTamanio = costosFlat.length;
    var anniosTamanio = null;

    for (var i = 0; i < costosFlatTamanio; i++) {
        var indexCategoria = obtenIndexPorParametroValor(categoriasDefinicion,
            "id", costosFlat[i].idPagoCateg, "index");
        var indexPeriodo = obtenIndexPorParametroValor(periodosDefinicion,
            "id", costosFlat[i].idContratoPago, "index");
        var indexAnio = null;

        var costo = costosFlat[i].costo;
        var idGroup = null;

        if (aniosDefinicion !== null) {
            anniosTamanio = aniosDefinicion.length;
            indexAnio = obtenIndexPorParametroValor(aniosDefinicion, "id",
                costosFlat[i].annio, "index");
            idGroup = (((indexPeriodo - 1) * anniosTamanio) + indexAnio) - 1;
        } else
            idGroup = indexPeriodo - 1;

        if (Number(idGroup) >= 0)
            actualizaJsonParametro(jsonData, "id", indexCategoria, "p" + idGroup, costo);

    }

    return jsonData;
}

function cargaJsonTitulosInformacion(minimosSeleccion, jsonData,
    categoriasDefinicion, periodosDefinicion, aniosDefinicion) {

    var minimosSeleccionTamanio = minimosSeleccion.length;
    var anniosTamanio = null;

    for (var i = 0; i < minimosSeleccionTamanio; i++) {

        var indexCategoria = obtenIndexPorParametroValor(categoriasDefinicion,
            "id", minimosSeleccion[i].idPagoCategoria, "index");
        var indexPeriodo = obtenIndexPorParametroValor(periodosDefinicion,
            "id", minimosSeleccion[i].idContratoPago, "index");
        var indexAnio = null;

        var minimoSeleccion = minimosSeleccion[i].minimoSeleccion;
        var idGroup = null;

        if (aniosDefinicion !== null) {
            anniosTamanio = aniosDefinicion.length;
            indexAnio = obtenIndexPorParametroValor(aniosDefinicion, "id",
                minimosSeleccion[i].annio, "index");
            idGroup = (((indexPeriodo - 1) * anniosTamanio) + indexAnio) - 1;
        } else
            idGroup = indexPeriodo - 1;

        if (Number(idGroup) >= 0) {

            if (indexCategoria !== null)
                actualizaJsonParametro(jsonData, "id", indexCategoria, "t" + idGroup, minimoSeleccion);
            else
                actualizaJsonParametro(jsonData, "id", indexCategoria, "m" + idGroup, minimoSeleccion);

        }
    }

    return jsonData;
}

function generaGridMinimos(grid, jsonData, categoriasDefinicion,
    periodosDefinicion, aniosDefinicion, rubrosDefinicion,
    rubrosDefinicionIds, anniosPeriodo) {

    var periodosTamanio = periodosDefinicion.length;
    var anniosTamanio = null;
    var rubrosTamanio = rubrosDefinicion.length;

    if (aniosDefinicion === null)
        anniosTamanio = 1;
    else
        anniosTamanio = aniosDefinicion.length;

    var columnasNames = generaColumnNames(".", rubrosDefinicion, anniosTamanio * periodosTamanio);
    var columnasModel = generaColumnModel("descCategoria", rubrosDefinicionIds,
        anniosTamanio * periodosTamanio);

    var groupingPeriodModel = generaPeriodoGrouping(periodosDefinicion,
        rubrosTamanio, anniosTamanio);
    var groupingAnioModel = null;

    if (aniosDefinicion !== null)
        groupingAnioModel = generaAnioGrouping(aniosDefinicion, rubrosTamanio,
            periodosTamanio);

    grid
        .jqGrid({
            colNames: columnasNames,
            colModel: columnasModel,
            datatype: "local",
            data: jsonData,
            rowNum: jsonData.length,
            viewrecords: true,
            width: 1000,
            height: 350,
            sortable: false,
            shrinkToFit: false,
            cellEdit: true, 
            cellsubmit: 'clientArray',
            loadComplete: function(data) {

                defineCeldasEditables(columnasModel);

                if (aniosDefinicion !== null)
                    defineCeldasOcultas(grid, columnasModel,
                        aniosDefinicion, periodosDefinicion,
                        anniosPeriodo);

            },
            afterSaveCell: function(rowid, name, val, iRow, iCol) {

                if (rowid !== "null") {
                    titulosValor = grid.jqGrid('getCell', rowid, name);

                    if (validateCifraTitulos(titulosValor)) {
                        costoValor = grid.jqGrid('getCell', rowid, name
                            .replace("t", "p"));
                        grid
                            .jqGrid(
                                "setCell",
                                rowid,
                                name.replace("t", "m"),
                                formatCurrency(
                                    Number(unformatCurrency(titulosValor)) * Number(unformatCurrency(costoValor)),
                                    2));

                    }
                }
            }

        });

    grid.jqGrid('setGroupHeaders', {
        useColSpanStyle: true,
        groupHeaders: groupingPeriodModel
    });

    if (aniosDefinicion !== null)
        grid.jqGrid('setGroupHeaders', {
            useColSpanStyle: true,
            groupHeaders: groupingAnioModel
        });

    fixFreezeColumnEditModel(grid);

}

function fixFreezeColumnEditModel(grid) {

    grid
        .bind(
            "jqGridLoadComplete jqGridInlineEditRow jqGridAfterEditCell jqGridAfterRestoreCell jqGridInlineAfterRestoreRow jqGridAfterSaveCell jqGridInlineAfterSaveRow",
            function() {
                fixPositionsOfFrozenDivs.call(this);
            });

    grid.jqGrid("setGridParam", {
        cellEdit: false
    });
    grid.jqGrid("setFrozenColumns");
    grid.jqGrid("setGridParam", {
        cellEdit: true

    });
    fixPositionsOfFrozenDivs.call(grid[0]);

    try {
        var p = grid.jqGrid("getGridParam"),
            tid = $.jgrid.jqID(p.id),
            colModel = p.colModel,
            i, n = colModel.length,
            cm, skipIds = [];

        for (i = 0; i < n; i++) {
            cm = colModel[i];
            if ($.inArray(cm.name, ["cb", "rn", "subgrid"]) >= 0 || cm.frozen) {
                skipIds.push("#jqgh_" + tid + "_" + $.jgrid.jqID(cm.name));
            }
        }

    } catch (e) {}

}

function ejecutaGuardadoModificados(grid, categoriasDefinicion,
    periodosDefinicion, aniosDefinicion, rubrosDefinicion) {

    var prefijoTitulosColumna = 't';
    var prefijoMinimoColumna = 'm';
    var rubrosDefinicionTamanio = rubrosDefinicion.length;
    var aniosDefinicionTamanio = null;
    var validaParcialMayor = false;

    var filasModificadas = grid.getChangedCells('dirty');

    var idContrato = $('#idContrato').val();

    if (aniosDefinicion !== null && aniosDefinicion.length > 0)
        aniosDefinicionTamanio = aniosDefinicion.length;

    var count = 0;
    var jsonString = '{"idContrato" :' + idContrato + ",";

    for (var i in filasModificadas) {

        var fila = filasModificadas[i];
        var indexCategoria = Number(fila["id"]);

        var idCategoria = obtenIndexPorParametroValor(categoriasDefinicion,
            "index", indexCategoria, "id");

        for (var columnaNombre in fila) {

            var prefijoTitulo = null;

            if (idCategoria !== null)
                prefijoTitulo = prefijoTitulosColumna;
            else
                prefijoTitulo = prefijoMinimoColumna;

            if (columnaNombre.indexOf(prefijoTitulo) > -1) {

                var valoresMinimos = grid.jqGrid("getCol", columnaNombre
                    .replace("t", "m"));
                var valoresMinimosSize = valoresMinimos.length;
                var minimosParcial = 0;

                if (valoresMinimosSize > 0) {

                    minimoTotal = Number(unformatCurrency(valoresMinimos[0]));

                    for (var i = 1; i < valoresMinimosSize; i++)
                        minimosParcial = minimosParcial + Number(unformatCurrency(valoresMinimos[i]));

                    if (minimosParcial > minimoTotal)
                        validaParcialMayor = true;

                }

                var idColumna = (Number(columnaNombre
                    .replace(prefijoTitulo, "")) * Number(rubrosDefinicionTamanio)) + Number(1);

                var valorGuardar = unformatCurrency(Number(fila[columnaNombre]));

                var indexAnio = null;
                var idAnio = null;

                var indexPeriodo = calculaIndexPeriodoColumna(idColumna,
                    aniosDefinicionTamanio, rubrosDefinicionTamanio);

                if (aniosDefinicionTamanio != null)
                    indexAnio = calculaIndexAnioColumna(idColumna,
                        aniosDefinicionTamanio, rubrosDefinicionTamanio);

                var idPeriodo = obtenIndexPorParametroValor(periodosDefinicion,
                    "index", indexPeriodo, "id");

                if (aniosDefinicionTamanio != null)
                    idAnio = obtenIndexPorParametroValor(aniosDefinicion,
                        "index", indexAnio, "id");

                jsonString = jsonString + '"minimosSeleccion[' + count + '].idContratoPago":' + idPeriodo + ',"minimosSeleccion[' + count + '].idPagoCategoria":' + idCategoria + ',"minimosSeleccion[' + count + '].annio":' + idAnio + ',"minimosSeleccion[' + count + '].minimoSeleccion":' + valorGuardar + ',';

                count = count + 1;

            }
        }

    }

    jsonString = jsonString.substr(0, jsonString.length - 1) + '}';

    if (validaParcialMayor === true)
        showError("La suma de los minimos parciales es mayor a la del minimo total definido");
    else if (count !== 0) {

        var jsonEnvia = JSON.parse(jsonString);
        callActionAjax("/contrato/minimoSeleccion/guardaMinimosSeleccionData",
            jsonEnvia, despuesGuardadoFunction);

    }

}

function obtenIndexPorParametroValor(lista, parametroEvalua, valorEvalua,
    parametroRegresa) {

    var item = null;
    for (var i in lista) {
        item = lista[i];

        if (item[parametroEvalua] === valorEvalua)
            return item[parametroRegresa];

    }

    return null;
}

function actualizaJsonParametro(jsonData, parametroEvalua, valorEvalua,
    parametroActualiza, valorActualiza) {

    for (var i = 0; i < jsonData.length; i++) {

        if (jsonData[i][parametroEvalua] == valorEvalua) {

            if (valorActualiza !== null)
                jsonData[i][parametroActualiza] = valorActualiza;
            else
                jsonData[i][parametroActualiza] = "0";

            break;
        }

    }

    return jsonData;

}

function cargaJsonCalculoMinimosInformacion(jsonData, nVariables) {
    for (var i = 1; i < jsonData.length; i++)
        for (var j = 0; j < nVariables; j++)
            jsonData[i]["m" + j] = jsonData[i]["t" + j] * jsonData[i]["p" + j];

    return jsonData;
}

function generaColumnNames(cFija, cVariables, nVariables) {

    var listColumnNames = [];
    var arrayLength = cVariables.length;

    listColumnNames.push(cFija);
    for (var i = 0; i < nVariables; i++)
        for (var j = 0; j < arrayLength; j++) {
            listColumnNames.push(cVariables[j]);
        }

    return listColumnNames;

}

function generaColumnModel(cFija, cVariables, nVariables) {

    var listColumnModel = [];
    var arrayLength = cVariables.length;

    listColumnModel.push({
        name: cFija,
        frozen: true,
        sortable: false

    });

    for (var i = 0; i < nVariables; i++)
        for (var j = 0; j < arrayLength; j++) {

            var editableMode = false;
            var customFunctionValidation = null;
            var customFunctionFormatter = currencyFmatter;

            if (cVariables[j] === "t" || cVariables[j] === "m") {
                editableMode = true;

                if (cVariables[j] === "t") {
                    customFunctionValidation = validatePositiveIntegerFunction;
                    customFunctionFormatter = integerFmatter;
                } else {
                    customFunctionValidation = validateCurrencyFunction;
                }
            }

            listColumnModel.push({
                name: cVariables[j] + i,
                editable: editableMode,
                editrules: {
                    custom: true,
                    custom_func: customFunctionValidation
                },

                formatter: customFunctionFormatter,
                unformat: unfmatterCurrency,
                sortable: false,
                align: "right"
            });

        }

    return listColumnModel;

}

function generaPeriodoGrouping(listaPeriodos, nRubros, nAnios) {

    var periodoGroupingModel = [];
    var nColumnaIntervalo = 0;

    periodoGroupingModel.push({
        startColumnName: 'descCategoria',
        numberOfColumns: 1,
        titleText: '.'
    });

    for (var i in listaPeriodos) {

        periodoGroupingModel.push({
            startColumnName: "t" + nColumnaIntervalo,
            numberOfColumns: nRubros * nAnios,
            titleText: listaPeriodos[i].desc
        });

        nColumnaIntervalo = nColumnaIntervalo + nAnios;
    }

    return periodoGroupingModel;
}

function generaAnioGrouping(listaAnios, nRubros, nPeriodos) {

    var anioGroupingModel = [];
    var nColumnaIntervalo = 0;
    var nAnios = listaAnios.length;

    anioGroupingModel.push({
        startColumnName: 'descCategoria',
        numberOfColumns: 1,
        titleText: '.'
    });

    for (var i = 0; i < nPeriodos; i++)
        for (var j = 0; j < nAnios; j++) {

            anioGroupingModel.push({
                startColumnName: "t" + nColumnaIntervalo,
                numberOfColumns: nRubros,
                titleText: listaAnios[j].desc
            });

            nColumnaIntervalo = nColumnaIntervalo + 1;
        }

    return anioGroupingModel;
}

function calculaIndexPeriodoColumna(columna, noAnios, noRubros) {

    var anioAbsoluto = null;
    var periodoAbsoluto = null;

    if (noAnios !== null) {
        anioAbsoluto = Math.ceil(columna / noRubros);
        periodoAbsoluto = Math.ceil(anioAbsoluto / noAnios);

    } else {
        periodoAbsoluto = Math.ceil(columna / noRubros);
    }

    return periodoAbsoluto;
};

function calculaIndexAnioColumna(columna, noAnios, noRubros) {

    var anioAbsoluto = Math.ceil(columna / noRubros);
    var anioRelativo = anioAbsoluto - ((Math.ceil(anioAbsoluto / noAnios) - 1) * noAnios);

    return anioRelativo;
};

function defineCeldasEditables(colModel) {

    var sizeColModel = colModel.length;
    var grid = $("#grid");

    for (var i = 0; i < sizeColModel; i++) {

        if (colModel[i].name.indexOf("t") > -1) {
            var cells = $("tbody > tr.jqgrow > td:nth-child(" + (i + 1) + ")",
                grid[0]);

            var cell = $(cells[0]);
            cell.addClass('not-editable-cell');

        }

        if (colModel[i].name.indexOf("m") > -1) {

            var cells = $("tbody > tr.jqgrow > td:nth-child(" + (i + 1) + ")",
                grid[0]);

            for (var j = 1; j < cells.length; j++) {
                var cell = $(cells[j]);
                cell.addClass('not-editable-cell');
            }

        }


    }

}

function defineCeldasEditables(colModel) {

    var sizeColModel = colModel.length;
    var grid = $("#grid");

    for (var i = 0; i < sizeColModel; i++) {

        if (colModel[i].name.indexOf("t") > -1) {
            var cells = $("tbody > tr.jqgrow > td:nth-child(" + (i + 1) + ")",
                grid[0]);

            var cell = $(cells[0]);
            cell.addClass('not-editable-cell');

        }

        if (colModel[i].name.indexOf("m") > -1) {

            var cells = $("tbody > tr.jqgrow > td:nth-child(" + (i + 1) + ")",
                grid[0]);

            for (var j = 1; j < cells.length; j++) {
                var cell = $(cells[j]);
                cell.addClass('not-editable-cell');
            }

        }

    }

}

function defineCeldasOcultas(grid, columnasModel, aniosDefinicion,
    periodosDefinicion, anniosPeriodo) {

    var anniosPeriodoTamanio = anniosPeriodo.length;
    var aniosDefinicionTamanio = aniosDefinicion.length;

    for (var i = 0; i < anniosPeriodoTamanio; i++) {

        var periodo = anniosPeriodo[i].idContratoPago;
        var noAnioPeriodoMax = anniosPeriodo[i].annio;

        var indexPeriodo = obtenIndexPorParametroValor(periodosDefinicion,
            "id", periodo, "index");

        for (var j = noAnioPeriodoMax + 1; j <= aniosDefinicionTamanio; j++) {

            var indexAnio = null;

            if (aniosDefinicion !== null) {
                anniosTamanio = aniosDefinicion.length;
                indexAnio = obtenIndexPorParametroValor(aniosDefinicion, "id",
                    j, "index");
                idGroup = (((indexPeriodo - 1) * anniosTamanio) + indexAnio) - 1;
                grid.jqGrid('hideCol', "t" + idGroup);
                grid.jqGrid('hideCol', "p" + idGroup);
                grid.jqGrid('hideCol', "m" + idGroup);
            }

        }

    }

}

fixPositionsOfFrozenDivs = function() {
    var $rows;
    if (typeof this.grid.fbDiv !== "undefined") {
        $rows = $('>div>table.ui-jqgrid-btable>tbody>tr', this.grid.bDiv);
        $('>table.ui-jqgrid-btable>tbody>tr', this.grid.fbDiv).each(
            function(i) {
                var rowHight = $($rows[i]).height(),
                    rowHightFrozen = $(
                        this).height();
                if ($(this).hasClass("jqgrow")) {
                    $(this).height(rowHight);
                    rowHightFrozen = $(this).height();
                    if (rowHight !== rowHightFrozen) {
                        $(this).height(
                            rowHight + (rowHight - rowHightFrozen));
                    }
                }
            });
        $(this.grid.fbDiv).height(this.grid.bDiv.clientHeight);
        $(this.grid.fbDiv).css($(this.grid.bDiv).position());
    }
    if (typeof this.grid.fhDiv !== "undefined") {
        $rows = $('>div>table.ui-jqgrid-htable>thead>tr', this.grid.hDiv);
        $('>table.ui-jqgrid-htable>thead>tr', this.grid.fhDiv).each(
            function(i) {
                var rowHight = $($rows[i]).height(),
                    rowHightFrozen = $(
                        this).height();
                $(this).height(rowHight);
                rowHightFrozen = $(this).height();
                if (rowHight !== rowHightFrozen) {
                    $(this).height(rowHight + (rowHight - rowHightFrozen));
                }
            });
        $(this.grid.fhDiv).height(this.grid.hDiv.clientHeight);
        $(this.grid.fhDiv).css($(this.grid.hDiv).position());
    }
};


function myTrim(x) {
    return x.replace(/^\s+|\s+$/gm, '');
}

function validaCifraTitulos(positiveIntegerString) {

    if (positiveIntegerString === "" || positiveIntegerString === "0")
        return true;
    else
    if (validatePositiveInteger(positiveIntegerString) === false)
        return false;
    else
        return true;
}


function validateCifraTotalMinimos(currencyString) {

    if (currencyString === "")
        return true;
    else
    if (validateCurrency(currencyString) === false)
        return false;
    else
        return true;
}

function validateCurrency(currencyString) {
    var currency_regex = /(?=.)^\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?(\.[0-9]{1,2})?$/;
    return currency_regex.test(currencyString);
}

function formatCurrency(unformatedCurrency, n, x) {
    var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
    return unformatedCurrency.toFixed(Math.max(0, ~~n)).replace(
        new RegExp(re, 'g'), '$&,');
};

function unformatCurrency(formatedCurrency) {
    return String(formatedCurrency).replace(/ /g, "").replace(/,/g, "")
        .replace("$", "");
};

function currencyFmatter(cellvalue, options, rowObject) {
    var formatedValue = "";

    if (cellvalue !== null)
        formatedValue = formatCurrency(Number(unformatCurrency(cellvalue)), 2);

    return formatedValue;
}

function unfmatterCurrency(cellvalue, options) {
    return unformatCurrency(cellvalue);
}

function validatePositiveInteger(positiveIntegerString) {
    var integer_regex = /(?!0)(?=.)^\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?$/;
    return integer_regex.test(positiveIntegerString);
}

function validateCifraTitulos(positiveIntegerString) {
    if (positiveIntegerString !== "0")
        if (validatePositiveInteger(positiveIntegerString) === false)
            return false;
        else
            return true;
    else return true;
}

function integerFmatter(cellvalue, options, rowObject) {
    var formatedValue = "";

    if (cellvalue !== null)
        formatedValue = formatCurrency(Number(unformatCurrency(cellvalue)));

    return formatedValue;
}

function validateCurrencyFunction(value, colname) {

    if (validateCurrency(value) === false)
        return [false, "No se ha tecleado una cantidad valida"];
    else
        return [true, ""];

}

function validatePositiveIntegerFunction(value, colname) {

    if (validateCifraTitulos(value) === false)
        return [false, "No se ha tecleado una cantidad valida"];
    else
        return [true, ""];


}


$(document)
    .ready(
        function() {

            var guardadoStatus = $("#guardadoStatus").val();

            if (validaNuloUndefinido(guardadoStatus) !== 0)
                if (Number(guardadoStatus) === 1)
                    showMessage("La informaci&oacute;n se ha guardado con exito");
                else
                    showError("Ocurrio un error durante el guardado");
            
            cargaTablaMinimosSeleccion();
            $("#guardarBoton").prop( "disabled", true ); 
            var perfilController = new PerfilController();
        	perfilController.ejecutarPerfil(parseInt($("#pmn").val()));

        }
    );