validacionesPromociones = function(tipoDescuento) {
	var mensaje = null;
	var tipo = tipoDescuento;

	if (mensaje == null) {
		if ($("#selectEstudios").val() == "0" || $("#selectEstudios").val() == "")
			mensaje = "Seleccione un t\u00EDtulo.";
	}

	if (mensaje == null) {
		if ($("#nombre_promocion").val() == "0" || $("#nombre_promocion").val() == "")
			mensaje = "Debes asignar un Nombre a la Promoci\u00F3n.";
	}

	if (mensaje == null) {
		if ($("#descuento").val() == "0" || $("#descuento").val() == "")
			mensaje = "Debes asignar un Descuento.";
	}

	if (mensaje == null) {
		if ($("#fecha_inicio").val() == "0" || $("#fecha_inicio").val() == "")
			mensaje = "Selecciona una fecha.";
	}

	if (mensaje == null) {
		if ($("#fecha_fin").val() == "0" || $("#fecha_fin").val() == "")
			mensaje = "Selecciona una fecha.";
	}

	if (mensaje == null) {
		if ($("#fecha_inicio").val() > $("#fecha_fin").val()) {
			mensaje = "Rango de Fechas no v\u00E1lido.";
		}
	}


	if (mensaje == null) {
		if (tipo == "PORCENTAJE") {
			if ($("#descuento").val() <= 0 || $("#descuento").val() > 100)
				mensaje = "Descuento no v\u00E1lido.";
		}

		if (tipo == "MONEDA") {
			if ($("#descuento").val() <= 0)
				mensaje = "Descuento no v\u00E1lido.";
		}
	}

	if (mensaje != null)
		$("#errorEditForm").text(mensaje).show();
	else
		$("#errorEditForm").text(mensaje).hide();
	return mensaje;
}

valActualizaPromocion = function(tipoDescuento) {
	var mensaje = null;
	var tipo = tipoDescuento;

	if (mensaje == null) {
		if ($("#updselectEstudios").val() == "0" || $("#updselectEstudios").val() == "")
			mensaje = "Seleccione un t\u00EDtulo.";
	}

	if (mensaje == null) {
		if ($("#updnombre_promocion").val() == "0" || $("#updnombre_promocion").val() == "")
			mensaje = "Debes asignar un Nombre a la Promoci\u00F3n.";
	}

	if (mensaje == null) {
		if ($("#upddescuento").val() == "0" || $("#upddescuento").val() == "")
			mensaje = "Debes asignar un Descuento.";
	}

	if (mensaje == null) {
		if ($("#updfecha_inicio").val() == "0" || $("#updfecha_inicio").val() == "")
			mensaje = "Selecciona una fecha.";
	}

	if (mensaje == null) {
		if ($("#updfecha_fin").val() == "0" || $("#updfecha_fin").val() == "")
			mensaje = "Selecciona una fecha.";
	}

	if (mensaje == null) {
		if ($("#updfecha_inicio").val() > $("#updfecha_fin").val()) {
			mensaje = "Rango de Fechas no v\u00E1lido.";
		}
	}


	if (mensaje == null) {
		if (tipo == "PORCENTAJE") {
			if ($("#upddescuento").val() <= 0 || $("#upddescuento").val() > 100)
				mensaje = "Descuento no v\u00E1lido.";
		}

		if (tipo == "MONEDA") {
			if ($("#upddescuento").val() <= 0)
				mensaje = "Descuento no v\u00E1lido.";
		}
	}

	if (mensaje != null)
		$("#errorUpdForm").text(mensaje).show();
	else
		$("#errorUpdForm").text(mensaje).hide();
	return mensaje;
}




var promocionesController = function($scope, $filter, promocionesService) {

	$scope.pEditPromo = false;
	$scope.pDetallePromo = false;
	$scope.pDelPromo = false;

	$scope.btnGuardarPromo = true;
	$scope.labelEstudioDisabled = true;
	$scope.promociones = '';
	$scope.titulos = '';
	$scope.titulosp = '';

	$scope.id_pais = '';
	$scope.descripcion = ''
	$scope.nombre_promocion = '';
	$scope.desc_estudio = '';
	$scope.descuento = '';
	$scope.fecha_inicio = '';
	$scope.fecha_fin = '';
	$scope.tipo_descuento = '';
	$scope.id_promocion = '';

	$('#btnVigentes').hide();

	$scope.datosForm = {
		nombre_promocion: "",
		descuento: "",
		fecha_inicio: "",
		fecha_fin: ""
	}

	/* 
	 * 
	 *    LLAMADA A SERVICIOS LISTADO DE PROMOCIONES
	 * 
	 * 
	 * */

	//se ejecuta al click de boton "incluir pasadas"
	$scope.mostrarPromociones = function() {

		$scope.promociones = '';
		$scope.promocionesOriginal = '';
		$('#btnVigentes').show();
		$('#btnIncluirTodas').hide();

		promocionesService.obtenerPromociones().then(
			function(data) {
				promocionL = [];

				$scope.promocionesOriginal = data;
				angular.forEach(data.promociones, function(item, $index) {

					promocionL.push(item);
				});

				$scope.promociones = promocionL;

			})
			.catch(function(error) {

			});

	}

	//se ejecuta al dar click en boton	
	$scope.promosVigentes = function() {

		$scope.promociones = '';
		$scope.promocionesOriginal = '';
		$('#btnVigentes').hide();
		$('#btnIncluirTodas').show();

		promocionesService.obtenerPromocionesVigentes().then(
			function(data) {
				promocionL = [];
				$scope.promocionesOriginal = data;
				angular.forEach(data.promociones, function(item, $index) {

					promocionL.push(item);
				});

				$scope.promociones = promocionL;

			})
			.catch(function(error) {

			});
	}

	//Se ejecuta funcion al llegar a la pantalla de promociones
	$scope.promosVigentes();


	//ejecuta el servicio de eliminar promo...
	$scope.eliminaPromo = function(id_promocion, nombre_promocion) {
		$scope.id_promocion = '';
		$scope.nombre_promo = '';
		$scope.id_promocion = id_promocion;
		$scope.nombre_promo = nombre_promocion;

		swal({
			title: "Esta seguro que desea eliminar la promocion: " + $scope.nombre_promo + " ?",
			text: "...",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: '#DD6B55',
			closeOnConfirm: false
		},
			function() {
				$scope.ejecutaEliminaPromo();

			});
	}

	$scope.ejecutaEliminaPromo = function() {
		promocionesService.eliminaPromocion($scope.id_promocion).then(
			function(data) {

				swal("Eliminada!", "La promocion Seleccionada se elimino...", "success");
				$scope.promosVigentes();

			});
	}

	/*
	 * 
	 * 
	 *  LLAMADAS A SERVICIOS - MODAL PROMOCIONES
	 *    
	 * 
	 * */
	$scope.listaEstudios = function() {
		$scope.estudios = '';

		promocionesService.obtenerEstudios().then(
			function(data) {
				estudiosL = [];
				angular.forEach(data.estudios, function(item, $index) {

					estudiosL.push(item);
				});

				$scope.estudios = estudiosL;

			});
	}

	$scope.listaPaises = function() {
		$scope.paises = '';

		promocionesService.obtenerPaises().then(
			function(data) {
				paisesL = [];
				angular.forEach(data.paises, function(item, $index) {

					paisesL.push(item);
				});

				$scope.paises = paisesL;

			});
	}

	//se ejecuta la funcion al cargar controller
	$scope.listaPaises();

	$scope.listaTitulos = function() {


		$scope.titulos = '';
		$scope.id_pais = '';

		if ($scope.paisSeleccionado != null && $scope.estudioSeleccionado != null) {

			promocionesService.obtenerTitulos($scope.paisSeleccionado.id_pais, $scope.estudioSeleccionado.id_estudio).then(
				function(data) {
					titulosL = [];
					angular.forEach(data.titulos, function(item, $index) {

						titulosL.push(item);
					});

					$scope.titulos = titulosL;

					if ($scope.titulos.length == 0) {
						$scope.btnGuardarPromo = true;
						swal("No se encontraron t\u00EDtulos.");
					} else {
						$scope.btnGuardarPromo = false;
					}

				});

		} else if ($scope.estudioSeleccionado != null) {
			//llamada a titulos de todos los paises
			promocionesService.obtenerTitulosTodos($scope.estudioSeleccionado.id_estudio).then(
				function(data) {
					titulosL = [];
					angular.forEach(data.titulos, function(item, $index) {

						titulosL.push(item);
					});

					$scope.titulos = titulosL;

					if ($scope.titulos.length == 0) {
						$scope.btnGuardarPromo = true;
						swal("No se encontraron T\u00EDtulos.");
					} else {
						$scope.btnGuardarPromo = false;
					}

				});
		} else {
			swal("Seleccione un Estudio.");
		}


	}

	$scope.updListaTitulos = function() {

		$scope.btnGuardarPromo = false;
		$scope.titulosp = '';
		$scope.id_pais = '';

		if ($scope.paisSeleccionado != null && $scope.estudioSeleccionado != null) {

			promocionesService.obtenerTitulos($scope.paisSeleccionado.id_pais, $scope.estudioSeleccionado.id_estudio).then(
				function(data) {
					titulosL = [];
					angular.forEach(data.titulos, function(item, $index) {

						titulosL.push(item);
					});

					$scope.titulosp = titulosL;

				});

		} else if ($scope.estudioSeleccionado != null) {
			//llamada a titulos de todos los paises
			promocionesService.obtenerTitulosTodos($scope.estudioSeleccionado.id_estudio).then(
				function(data) {
					titulosL = [];
					angular.forEach(data.titulos, function(item, $index) {

						titulosL.push(item);
					});

					$scope.titulosp = titulosL;

				});
		} else {
			swal("Seleccione un Estudio.");
		}


	}

	$scope.guardarPromocion = function() {
		var tipoDescuento = "";
		var oper = document.getElementsByName('tipo_descuento');
		var seleccionTitulos = document.getElementsByName('checksBoxPromo');
		var seleccionoTitulo = 0;



		$scope.datosForm.fecha_inicio = document.getElementById('fecha_inicio').value;
		$scope.datosForm.fecha_fin = document.getElementById('fecha_fin').value;
		$scope.datosForm.nombre_promocion = document.getElementById('nombre_promocion').value;
		$scope.datosForm.descuento = document.getElementById('descuento').value;

		// se valida que al menos se seleccione un descuento y se recuperan los elementos seleccionados
		idBv_SelectL = [];
		$scope.idBv_Select = '';
		for (var k = 0; k < seleccionTitulos.length; k++) {
			if (seleccionTitulos[k].checked) {
				seleccionoTitulo = seleccionoTitulo + 1;
				idBv_SelectL.push(seleccionTitulos[k].value);
			}

		}

		$scope.idBv_Select = idBv_SelectL;

		//se obtiene el tipo de descuento
		for (var i = 0; i < oper.length; i++) {
			if (oper[i].checked)
				tipoDescuento = oper[i].value;
		}

		// si se selecicono al menos un titulo se guarda promocion y sus titulos asociados
		if (seleccionoTitulo > 0 && validacionesPromociones(tipoDescuento) == null && $scope.paisSeleccionado != null) {
			if ($scope.paisSeleccionado.id_pais == '')
				$scope.paisSeleccionado.id_pais = null;

			promocionesService.crearPromocion($scope.estudioSeleccionado.id_estudio, $scope.paisSeleccionado.id_pais, $scope.datosForm.nombre_promocion, $scope.datosForm.fecha_inicio, $scope.datosForm.fecha_fin, tipoDescuento, $scope.datosForm.descuento).then(
				function(data) {
					for (var a = 0; a < $scope.idBv_Select.length; a++) {
						promocionesService.registraPromocionTitulos(data.promocion.id_promocion, $scope.idBv_Select[a]).then(
							function(data) {

							});
					}
					$scope.promosVigentes();
					$('#modalPromociones').modal('hide');
					swal("Correcto!", "Se ha creado la Promoci\u00F3n...", "success");

				});

		} else if (seleccionoTitulo > 0 && $scope.paisSeleccionado == null && validacionesPromociones(tipoDescuento) == null) {

			$scope.id_pais = null;
			promocionesService.crearPromocion($scope.estudioSeleccionado.id_estudio, $scope.id_pais, $scope.datosForm.nombre_promocion, $scope.datosForm.fecha_inicio, $scope.datosForm.fecha_fin, tipoDescuento, $scope.datosForm.descuento).then(
				function(data) {
					//si la promo se dio de alta correctamente se insertan sus ids bv asociado
					for (var a = 0; a < $scope.idBv_Select.length; a++) {
						promocionesService.registraPromocionTitulos(data.promocion.id_promocion, $scope.idBv_Select[a]).then(
							function(data) {

							});
					}
					$scope.promosVigentes();
					$('#modalPromociones').modal('hide');
					swal("Correcto!", "Se ha creado la Promoci\u00F3n...", "success");

				});

		} else {
			swal("Falta informaci\u00F3n por completar.");
		}

	}//fin de guardarPromo

	$scope.obtenerTitulosPromocion = function(id_promocion, id_pais, id_estudio) {
		$scope.titulosPromocion = '';
		$scope.titulosp = '';
		$scope.id_pais = id_pais;

		promocionesService.obtenerPromocionTitulos(id_promocion).then(
			function(data) {
				titulosPromocionL = [];

				angular.forEach(data.promociontitulos, function(item, $index) {

					titulosPromocionL.push(item);
				});

				$scope.titulosPromocion = titulosPromocionL;

				if ($scope.id_pais != '' && $scope.id_pais != null) {
					promocionesService.obtenerTitulos(id_pais, id_estudio).then(
						function(data) {
							titulosL = [];

							angular.forEach(data.titulos, function(item, $index) {

								titulosL.push(item);
							});

							$scope.titulosp = titulosL;

							$('#modalActualizaPromocion').modal('show');

						});

				} else {
					promocionesService.obtenerTitulosTodos(id_estudio).then(
						function(data) {
							titulosL = [];

							angular.forEach(data.titulos, function(item, $index) {

								titulosL.push(item);
							});

							$scope.titulosp = titulosL;

							$('#modalActualizaPromocion').modal('show');

						});
				}

			});
	}

	$scope.actualizarPromocion = function() {
		var tipoDescuento = "";
		var oper = document.getElementsByName('updtipo_descuento');
		var seleccionTitulos = document.getElementsByName('checksBoxPromo');
		var seleccionoTitulo = 0;

		$scope.datosForm.fecha_inicio = document.getElementById('updfecha_inicio').value;
		$scope.datosForm.fecha_fin = document.getElementById('updfecha_fin').value;
		$scope.datosForm.nombre_promocion = document.getElementById('updnombre_promocion').value;
		$scope.datosForm.descuento = document.getElementById('upddescuento').value;

		// se valida que al menos se seleccione un titulo
		idBv_SelectL = [];
		$scope.idBv_Select = '';
		for (var k = 0; k < seleccionTitulos.length; k++) {
			if (seleccionTitulos[k].checked) {
				seleccionoTitulo = seleccionoTitulo + 1;
				idBv_SelectL.push(seleccionTitulos[k].value);
			}

		}

		$scope.idBv_Select = idBv_SelectL;

		//se obtiene el tipo de descuento
		for (var i = 0; i < oper.length; i++) {
			if (oper[i].checked)
				tipoDescuento = oper[i].value;
		}


		//si hay un titulo seleccionado se actualiza la promocion
		if (seleccionoTitulo > 0 && valActualizaPromocion(tipoDescuento) == null && $scope.paisSeleccionado != null) {
			if ($scope.paisSeleccionado.id_pais == '')
				$scope.paisSeleccionado.id_pais = null;

			promocionesService.actualizaPromocion($scope.id_promocion, $scope.paisSeleccionado.id_pais, $scope.datosForm.nombre_promocion, $scope.datosForm.fecha_inicio, $scope.datosForm.fecha_fin, tipoDescuento, $scope.datosForm.descuento).then(
				function(data) {

					//Se eliminan registros de Titulos para actualizar
					promocionesService.eliminaTitulosPromocion($scope.id_promocion).then(
						function(data) {

							//si la promo se Actualizo y Elimino los registros anterior de Titulos correctamente se insertan sus ids bv asociado
							for (var a = 0; a < $scope.idBv_Select.length; a++) {
								promocionesService.registraPromocionTitulos($scope.id_promocion, $scope.idBv_Select[a]).then(
									function(data) {

									});
							}

							$scope.promosVigentes();
							$('#modalActualizaPromocion').modal('hide');
							swal("Correcto!", "Se ha Actualizado la Promoci\u00F3n...", "success");

						});


				});

		} else if (seleccionoTitulo > 0 && valActualizaPromocion(tipoDescuento) == null && $scope.paisSeleccionado == null) {
			$scope.id_pais = null;

			promocionesService.actualizaPromocion($scope.id_promocion, $scope.id_pais, $scope.datosForm.nombre_promocion, $scope.datosForm.fecha_inicio, $scope.datosForm.fecha_fin, tipoDescuento, $scope.datosForm.descuento).then(
				function(data) {

					//Se eliminan registros de Titulos para actualizar
					promocionesService.eliminaTitulosPromocion($scope.id_promocion).then(
						function(data) {

							//si la promo se Actualizo y Elimino los registros anterior de Titulos correctamente se insertan sus ids bv asociado
							for (var a = 0; a < $scope.idBv_Select.length; a++) {
								promocionesService.registraPromocionTitulos($scope.id_promocion, $scope.idBv_Select[a]).then(
									function(data) {

									});
							}

							$scope.promosVigentes();
							$('#modalActualizaPromocion').modal('hide');
							swal("Correcto!", "Se ha Actualizado la Promoci\u00F3n...", "success");

						});


				});
		} else {
			swal("Complete la informaci\u00F3n requerida.");
		}


	}


	/*
	 * 
	 * 
	 *    FUNCIONES GENERALES
	 * 
	 * 
	 * */
	$scope.isChecked = function(id_bv) {

		var match = false;

		for (var T = 0; T < $scope.titulosPromocion.length; T++) {
			if ($scope.titulosPromocion[T].id_bv == id_bv) {
				match = true;
			}
		}
		return match;
	}

	$scope.isCheckedTypeP = function(id) {
		var check = false;

		if ($scope.tipo_descuento == document.getElementById(id).value) {
			check = true;
		}
		return check;
	}

	$scope.openAgregaPromocion = function() {

		$scope.listaEstudios();
		$scope.listaPaises();
		$scope.titulos = '';
		document.getElementById("nombre_promocion").value = "";
		document.getElementById("descuento").value = "";
		document.getElementById("fecha_inicio").value = "";
		document.getElementById("fecha_fin").value = "";
		$scope.btnGuardarPromo = true;

		$('#modalPromociones').modal('show');
	}


	$scope.openActualizaPromocion = function(id_promocion) {
		$scope.id_pais = '';
		$scope.descripcion = ''
		$scope.nombre_promocion = '';
		$scope.desc_estudio = '';
		$scope.descuento = '';
		$scope.titulos = '';
		$scope.fecha_inicio = '';
		$scope.fecha_fin = '';
		$scope.tipo_descuento = '';
		$scope.id_promocion = '';

		$scope.estudioSeleccionado = {
			id_estudio: '',
			desc_estudio: ''
		}
		$scope.paisSeleccionado = {
			id_pais: "",
			descripcion: ""
		}

		for (var p = 0; p < $scope.promociones.length; p++) {

			if ($scope.promociones[p].id_promocion == id_promocion) {

				$scope.id_promocion = $scope.promociones[p].id_promocion;
				$scope.id_pais = $scope.promociones[p].id_pais;
				$scope.desc_estudio = $scope.promociones[p].desc_estudio;
				$scope.nombre_promocion = $scope.promociones[p].nombre_promocion;
				$scope.descuento = $scope.promociones[p].descuento;
				document.getElementById("updfecha_inicio").value = $scope.promociones[p].fecha_inicio;
				document.getElementById("updfecha_fin").value = $scope.promociones[p].fecha_fin;
				$scope.tipo_descuento = $scope.promociones[p].tipo_descuento;

				$scope.estudioSeleccionado.id_estudio = $scope.promociones[p].id_estudio;
			}
		}
		for (var p = 0; p < $scope.paises.length; p++) {
			if ($scope.paises[p].id_pais == $scope.id_pais) {
				$scope.descripcion = $scope.paises[p].descripcion;
				$scope.paisSeleccionado.descripcion = $scope.paises[p].descripcion;
				$scope.paisSeleccionado.id_pais = $scope.id_pais;
			}
		}

		document.getElementById("updpaisSeleccionado").value = $scope.descripcion;

		//llenado de tabla titulos
		$scope.obtenerTitulosPromocion(id_promocion, $scope.id_pais, $scope.estudioSeleccionado.id_estudio);//se obtiene el listado de titulos que contiene la promo a modif...

	}



	//funciones que ordenan tabla promociones
	$scope.sort = {
		column: '',
		descending: false
	};

	$scope.changeSorting = function(column) {

		var sort = $scope.sort;

		if (sort.column == column) {
			sort.descending = !sort.descending;
		} else {
			sort.column = column;
			sort.descending = false;
		}
	};

	$scope.selectedCls = function(column) {
		return column == $scope.sort.column && 'sort-' + $scope.sort.descending;
	};

	//funciones para tabla agrupada modifica promo
	$scope.updTitulosToFilter = function() {
		indexedTitulos = [];
		return $scope.titulosp;
	}

	//funciones para tabla agrupada agrega promo
	indexedTitulos = [];
	$scope.titulosToFilter = function() {
		indexedTitulos = [];
		return $scope.titulos;
	}

	$scope.filterTitulos = function(titulo) {
		var tituloIsNew = indexedTitulos.indexOf(titulo.numero_contrato) == -1;
		if (tituloIsNew) {
			indexedTitulos.push(titulo.numero_contrato);
		}
		return tituloIsNew;
	}




};

registraController("promocionesController", promocionesController);