var revenueService  = function($filter, $http, $q, tablaService, terminosValidateService) {

	return {

	    crearTablaRevenue: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, subEncabezadosRevenue:null, valida:true, nombre: "Revenue"};

	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push({"valor":encabezados[i], "colspan":"1"});
	    		    	
	    	tabla.datos = [];
	    	
	    	if(data != null)
	    	{
	    		for(var i=0; i < data.length;i++)
			    {
			   	   var fila = [];
			       for(var j=0; j < data[0].length;j++)
				   {		    		    		
			    	   if(data[i][j] == null)
			    		 fila.push( {"valor" : null} );
			    	   else if(j>0)
			    		 fila.push({"valor" : $filter('numDigMoneda')(data[i][j], 2)});
			    	   else
			    		 fila.push({"valor" : data[i][j]});
			    		  
				   }	
			       tabla.datos.push(fila);
			    }	
	    	}		   	
		   	
		   	tabla.subEncabezadosPrecio  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezadosPrecio.push("% DLA");
		   		tabla.subEncabezadosPrecio.push("% ESTUDIO");
		   	}	
		   	
	        return tabla;
	    },
	    	
	    crearTablaRevenueMovie: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, subEncabezadosRevenue:null, valida:true, nombre: "Revenue"};
	    		    		    	
	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push({"valor":encabezados[i], "colspan":"1"});
	    		    	
	    	tabla.datos = [];
	    	
	    	if(data != null)
	    	{
	    		for(var i=0; i < data.length;i++)
			    {
			   	   var fila = [];
			       for(var j=0; j < data[0].length;j++)
				   {		    		    		
			    	   if(data[i][j] == null)
			    		 fila.push( {"valor" : null} );
			    	   else if(j>0)
			    		 fila.push({"valor" : $filter('numDigMoneda')(data[i][j], 2)});
			    	   else
			    		 fila.push({"valor" : data[i][j]});
			    		  
				   }	
			       tabla.datos.push(fila);
			    }	
	    	}		   	
		   	
		   	tabla.subEncabezados  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezados.push("% DLA");
		   		tabla.subEncabezados.push("% ESTUDIO");
		   	}			   		    		    		
		       		    				   		   	
	        return tabla;
	    },
	    
	    actualizarRevenueCelda: function(fila, columna, valor, datos) {		
	    	var valClean = $filter('numDigNormal')(datos[fila][columna].valor, 2);
	    	
			var resto    = null;
			
			if (!isNaN(valClean) && parseFloat(valClean) > 0) 
			{
				if (valClean > 100 || valClean < 0)
					valClean = 0;
				else
					resto = 100 - valClean;

			}
			
			if (resto != null)
				resto = $filter('numDigMoneda')(String(resto), 2);
			datos[fila][columna + 1].valor = resto;
			return datos;
		},
		
		editarTablaRevenue : function(operacion, index, tablaRevenue) {
			var tablaNueva;
			switch (operacion) 
			{		
				case 'removeRow':
					tablaNueva = tablaService.removeRow(tablaRevenue.datos, index);
					break;
				case 'addRow':
					tablaNueva = tablaService.addRow(tablaRevenue.datos);
					break;
				default:
			}
			tablaRevenue.datos       = tablaNueva.datos       != null ? tablaNueva.datos      : tablaRevenue.datos;
			tablaRevenue.encabezados = tablaNueva.encabezados != null ? tablaNueva.encabezados: tablaRevenue.encabezados;
			return tablaRevenue;
		},
		
		validarRevenue : function(tablaRevenue, opciones, validaCadaOpcion, validaUnicaVacia) {
			
			var continuar = true;
			var tablaModelExcepciones = this.convierteModeloExcepciones(tablaRevenue);
			var resultado = {validacion : true, mensaje: ""};
			var unicaVacia = tablaModelExcepciones.excepciones.length == 1 && this.esTituloArregloInvalido(tablaModelExcepciones.excepciones[0], null, true);
			if(validaUnicaVacia){
			   if(!unicaVacia){
			      resultado = this.validaDatosTablaVacios(tablaModelExcepciones.excepciones, opciones, validaCadaOpcion);
				  if(resultado.validacion)
					 resultado = this.validaPeriodosTabla(tablaModelExcepciones.periodos);
			   }
			}else{
				  resultado = this.validaDatosTablaVacios(tablaModelExcepciones.excepciones, opciones, validaCadaOpcion);
				  if(resultado.validacion)
						 resultado = this.validaPeriodosTabla(tablaModelExcepciones.periodos);
			}

			continuar = terminosValidateService.mensajeValidacion(resultado.validacion, "", resultado.mensaje); 
			
			return continuar;
		},
		
		crearTablaRevenueGlobal : function(data){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Revenue"};
	    	
	    	tabla.datos = [];	    	
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    		    		
		    	   if(data[i][j] == null)
		    		  fila.push({"valor" : null});
		    	   else
		    	      fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});		    	
			   }	
		       tabla.datos.push(fila);
		    }
		   	
	        return tabla;
	    },
	    	    
	    crearTablaRevenueBox: function(data, encabezados){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Revenue"};
	    	
	    	tabla.metadatos= [  {"nombre":"rango a",   "tipo":"text", "min":1, "max":10, "formateo":"texto"},
	   	                        {"nombre":"rango b",   "tipo":"text", "min":1, "max":10, "formateo":"texto"},
	   	                        {"nombre":"categoria", "tipo":"String", "min":1, "max":25, "formateo":"texto"},
	   	                        {"nombre":"rango b",   "tipo":"text", "min":1, "max":10, "formateo":"texto"},
	   	                        {"nombre":"rango b",   "tipo":"text", "min":1, "max":10, "formateo":"texto"},
	   	                     ];	    		    	
	    	tabla.datos = [];
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		   
		    	   if(data[i][j] == null)
		    		   fila.push({"valor" : null, "editable":true});
		           else  if(j>= 3)
		    	       fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2), "editable":true});
		    	    else if(j <= 1)
		    		   fila.push({"valor" : $filter('number')(data[i][j]), "editable":true});
		    	    else
		    	       fila.push({"valor" : data[i][j], "editable":true});
			   }	
		       tabla.datos.push(fila);
		    }
		   	
		   	tabla.encabezados = [];
		   	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push({"valor":encabezados[i], "colspan":"1"});
		   	
		   	tabla.subEncabezadosPrecio  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezadosPrecio.push("% DLA");
		   		tabla.subEncabezadosPrecio.push("% ESTUDIO");
		   	}
		   	
		   	tabla.mensajes = [];
			for(var i=0; i < data.length;i++)
			    tabla.mensajes.push("");
			
	        return tabla;
	    },
		
	    actualizarRevenueGlobalCelda: function(fila, columna, valor, tablaRevenueLib){		      	  
			  var valClean =  $filter('numDigNormal')(valor.srcElement.value);
	   	      var resto    = 0;
	   	     	      
		   	  if(!isNaN(valClean) && valClean != "")
		   	  {
		   		  if(valClean > 100 || valClean < 0)
		   	    	valClean = 0;
		   	      else
		   	    	resto = 100 - valClean;  
		   		  
		   		  tablaRevenueLib.datos[fila][columna].valor = $filter('numDigMoneda')(String(valClean),2);
		   		  tablaRevenueLib.datos[fila][columna+1].valor = $filter('numDigMoneda')(String(resto),2);
		   	  }	  
		   	  
		   	  return tablaRevenueLib;
		  },
		 	  
		actualizarRevenueBoxCelda: function(fila, columna, valor, tablaRevenueBoxLib){		      	  		  		  
			  var valClean =  $filter('numDigNormal')(valor.srcElement.value);
	   	      	  
			  if(columna == 3)
			  {
				  var resto    = 0;		   	  
			   	  if(!isNaN(valClean) && valClean != "")
			   	  {
			   		  if(valClean > 100 || valClean < 0)
			   	    	valClean = 0;
			   	      else
			   	    	resto = 100 - valClean;  
			   		  
			   		  tablaRevenueBoxLib.datos[fila][columna].valor   = $filter('numDigMoneda')(String(valClean),2);
			   		  tablaRevenueBoxLib.datos[fila][columna+1].valor = $filter('numDigMoneda')(String(resto),2);
			   	  }		   	 		   	  		   	    
			  }					  
			  return tablaRevenueBoxLib;  
		},
		  
		validarRevenueBoxGlobal: function(tipoRevenue, tablaRevenueGlobal, tablaRevenueBoxLib){
			  	 var continuar = true;
			     if(tipoRevenue == "box")
		    	 {
		    		  tablaRevenueBoxLib.datos[0][0].valor = 1;
				      tablaRevenueBoxLib.datos[0][1].valor = 1;	    	 
				      tablaRevenueBoxLib = terminosValidateService.validarCeldasVacias(tablaRevenueBoxLib, 4, true);
				      continuar = terminosValidateService.mensajeValidacion(tablaRevenueBoxLib.valida, tablaRevenueBoxLib.nombre, "");	    	 
				      tablaRevenueBoxLib.datos[0][0].valor = null;
				      tablaRevenueBoxLib.datos[0][1].valor = null;	 			    	 			    	 	 
		    	 }
			  	 else if(tipoRevenue == "global")
			  	 {
			  		  if(tablaRevenueGlobal.datos[0][0].valor == null || tablaRevenueGlobal.datos[0][0].valor == "")
			  		  {
			  			continuar = false;
			  			showError("No se ha registrado un valor en Revenue Global");
			  		  }			  			  
			  	 }			  	 		
			  	 else
			  	 {
			  		continuar = false;
			  		showError("No se ha seleccionado ningún valor de Revenue");
			  	 }
			  		 
			     return continuar;
		},
		  
		generaModeloTablaExcepciones: function(data){
		    	
			    var tabla = {periodos:[], conceptos:[], excepciones:[], titulos:[], eleccion:null};
		    	var infoExcepciones = data.excepciones;
		    	var periodos = infoExcepciones.periodos;
		    	var excepciones = infoExcepciones.excepciones;
		    	var titulos = infoExcepciones.titulos;
		    	
		    	for(var i=0; i<periodos.length; i++)
		    		tabla.periodos.push({"valor":periodos[i]});
		    		    	
		    	tabla.excepciones = this.poblaModeloTitulosExcepcionTabla(excepciones);	
		    	tabla.titulos = this.poblaModeloTitulosExcepcionTabla(titulos);		   	

			   	for(var j=0; j < periodos.length;j++)
			   	{
			   		tabla.conceptos.push("% DLA");
			   		tabla.conceptos.push("% ESTUDIO");
			   	}	
			   	
		        return tabla;
		},
		
		poblaModeloTitulosExcepcionTabla: function(tituloExcepcion){
		    	
		    	var resultado = [];
		    	
		    	if(tituloExcepcion != null)
		    	{
		    		for(var i=0; i < tituloExcepcion.length;i++)
				    {
				   	   var fila = [];
				       for(var j=0; j < tituloExcepcion[0].length;j++)
					   {		    		    		
				    	  if(tituloExcepcion[i][j] == null)
				    		 fila.push( {"valor" : null} );
				    	  else 
				    		 if(j>1)
				    		     fila.push({"valor" : $filter('numDigMoneda')(tituloExcepcion[i][j], 2)});
				    	     else
				    		     fila.push({"valor" : tituloExcepcion[i][j]});
				    		  
					   }	
				       resultado.push(fila);
				    }	
		    	}
		    	
		    	return resultado;
		}, 
		
		generaMatrizExcepciones: function(excepciones){
		    	var datos = [];

		    	if(excepciones != null){
				 for(var i=0;i< excepciones.length;i++)
				 {
					 if(!this.esTituloArregloInvalido(excepciones[i], null, true)){
					  var fila = [];
					  for(var j=0;j< excepciones[i].length;j++)
						  fila[j] =  excepciones[i][j].valor;

					  datos.push(fila);
					 }else return [];
				 }		
		    	}
		         return datos;
		}, 
		
		generaMatrizPeriodos: function(periodos){
		    	 var datos = [];
				 for(var i=0;i< periodos.length;i++)			   			
					  datos.push(periodos[i].valor);	
 
		         return datos;
		},
		
		copiaReferenciaTablaModelo: function(origen, destino){
		    
		    destino.periodos = [];
		    destino.conceptos = []; 
		    destino.excepciones = []; 
		    destino.titulos = [];
		    destino.eleccion = null;
		    
		    for(var i=0; i<origen.periodos.length; i++)
		    	destino.periodos.push(origen.periodos[i])
		    
		    for(var i=0; i<origen.conceptos.length; i++)
		    	destino.conceptos.push(origen.conceptos[i])
		    
			for(var x=0; x<origen.excepciones.length; x++){
				var fila = [];
				for(var y=0; y<origen.excepciones[x].length; y++)
					fila.push(origen.excepciones[x][y]);
				destino.excepciones.push(fila);
			}
		    
			for(var x=0; x<origen.titulos.length; x++){
				var fila = [];
				for(var y=0; y<origen.titulos[x].length; y++)
					fila.push(origen.titulos[x][y]);
				destino.titulos.push(fila);
			}
			
			destino.eleccion = angular.copy(origen.eleccion);
		},
		
		esTituloArregloInvalido : function(arreglo, opciones, validaCadaOpcion){
			var vaciosContador = 0;
			var opcionesCheca = [];

			 if (!arreglo) return true;

			 if(opciones && opciones != null){
			 if (opciones.constructor === Array){
			  for(var i=0; i<opciones.length; i++)
				  opcionesCheca.push(opciones[i]);
			 }
			 else if (typeof(opciones) === 'number' &&
			            isFinite(opciones) &&
			            Math.round(opciones) === opciones){

			  for(var i=0; i<opciones; i++)
				opcionesCheca.push(i);
			 }
			 }else{ 				 
				 for(var i=0; i<arreglo.length; i++)
					  opcionesCheca.push(i);
			 }
			 
			for(var x=0;  x<arreglo.length; x++)
			 for(var i=0; i<opcionesCheca.length; i++)
			  if(x == opcionesCheca[i])
			   if (terminosValidateService.esStringVacio(arreglo[x].valor)) 
				vaciosContador ++;
			 
			if(validaCadaOpcion){
			  if(vaciosContador == opcionesCheca.length)
			    return true;
			}else{
			  if(vaciosContador > 0)
			    return true;
			}
			
			return false;
		},
		
		validarExepciones : function(tabla, evitaPrimeraFilaValidacion) {
			
	    	var resultado = {validacion : true, mensaje: ""};
			
			if(tabla && tabla.excepciones){
				
				   if(evitaPrimeraFilaValidacion && evitaPrimeraFilaValidacion === true){
				   if(tabla.excepciones.length == 1 && this.esTituloArregloInvalido(tabla.excepciones[0], null, true)){
					   
				   }else
				   for(var x=0 ; x<tabla.excepciones.length; x++){
					   for(y=0 ; y<tabla.excepciones[x].length; y++){
						   
						   if(terminosValidateService.esStringVacio(tabla.excepciones[x][y].valor)){
							   resultado.validacion = false;
							   resultado.mensaje = "Se debe registrar todos los valores de revenue";
							   break;
						   } 
					   }
				   }
				   }else
					   for(var x=0 ; x<tabla.excepciones.length; x++){
						   for(y=0 ; y<tabla.excepciones[x].length; y++){
							   
							   if(terminosValidateService.esStringVacio(tabla.excepciones[x][y].valor)){
								   resultado.validacion = false;
								   resultado.mensaje = "Se debe registrar todos los valores de revenue";
								   break;
							   } 
						   }
					   }
				   
				   if(resultado.validacion){
					   var periodos = [];
					   for(var x=0 ; x<tabla.periodos.length; x++){
							var fechas = tabla.periodos[x].valor.split("-");
						    periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]});
					   }
					   
					   resultado = terminosValidateService.validarFechasPeriodos(periodos);
				   }
			}
			
			return resultado;
		},
		
		validaDatosTablaVacios : function(tabla, opciones, validaCadaOpcion){
	    	var resultado = {validacion : true, mensaje: ""};
			if(tabla){
				for(var x=0 ; x<tabla.length; x++){
					if(this.esTituloArregloInvalido(tabla[x], opciones, validaCadaOpcion))
					{
						resultado.validacion = false;
						resultado.mensaje = "Se debe registrar todos los valores de revenue";
						break;
					}
				}
			}			
			return resultado;
		},
		
		validaPeriodosTabla  : function(tabla){
			
			   var periodos = [];
			   for(var x=0 ; x<tabla.length; x++){
					var fechas = tabla[x].valor.split("-");
				    periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]});
			   }
			   
			   resultado = terminosValidateService.validarFechasPeriodos(periodos);

			   if(resultado.validacion)
				   if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaInicioCto").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodos[0].fechaInicio).getTime()) ||  	    
						   ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaFinCto").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodos[periodos.length-1].fechaFin).getTime()) )
					   {
					      
					       resultado.validacion = false;
					       resultado.mensaje =  "El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato.";
					   }
			   
			   return resultado;
		},
		
		convierteModeloExcepciones : function(tabla) {
	    	var resultado = { periodos:[], excepciones:[] };
	    	
	    	for(var x=0; x<tabla.datos.length; x++){
	    		var fila = [];
	    		for(var y=0; y<tabla.datos[x].length; y++)
	    			fila.push(tabla.datos[x][y]);
	    		resultado.excepciones.push(fila);
	    	}
	    	
    		for(var x=0; x<tabla.encabezados.length; x++)
    			resultado.periodos.push(tabla.encabezados[x]);
    		
			return resultado;
		},
		
		calculaRevenueCelda : function(fila, columna, tabla) {
			var celdaDesdeValor = tabla[fila][columna].valor;

	    	if (isNaN(parseFloat(celdaDesdeValor)) || isNaN(Number(celdaDesdeValor)) ||
	    			parseFloat(celdaDesdeValor) > 100 || 
	    			  parseFloat(celdaDesdeValor) < 0) celdaDesdeValor = "";

	    	
	    	if(!terminosValidateService.esStringVacio(celdaDesdeValor)){
	        	celdaDesdeValor = $filter('numDigNormal')(celdaDesdeValor, 2);
	        	
	    		var resto = 100 - parseFloat(celdaDesdeValor);
	    		resto = $filter('numDigMoneda')(String(resto), 2);
	    		
	    		tabla[fila][columna + 1].valor = resto;
	    	}else tabla[fila][columna + 1].valor = "";
	    	
			tabla[fila][columna].valor = celdaDesdeValor;

		},
		
		eliminaFilasVaciasEnTabla : function(tabla, opciones){
			   var eliminados = [];
			
			   for(var x=0; x<tabla.length; x++)
				   if(this.esTituloArregloInvalido(tabla[x], opciones, true))
					     eliminados.push(x);
			
			   for(var i=0; i<eliminados.length; i++)
				   tabla.splice(eliminados[i], 1);
		},
		
		generaPeriodos: function(periodos){
	    	 var datos = [];
			 for(var i=0;i< periodos.length;i++)			   			
				  datos.push({"valor" : periodos[i][0].valor});	

	         return datos;
	   }
		
		
    };	
};

registraService("revenueService", revenueService);