function TituloService() {
	this.titulo = "";
}

TituloService.prototype.guardarTitulo = function(titulo, idLista, func) {
	var resultado;
	
	this.ajax("agregarTitulo", { titulo: JSON.stringify(titulo), idLista:idLista } , 
			  function (ret) { func(ret);                                         }, 
			  function (ret) { $("#errorEditForm").text(ret.error).show(); });
	return resultado;
};

TituloService.prototype.editarTitulo = function(titulo, idLista, func) {
	var resultado;
	
	this.ajax("editarTitulo", { titulo: JSON.stringify(titulo), idLista:idLista } , 
			  function (ret) { func(ret);                                         }, 
			  function (ret) { $("#errorEditForm").text(ret.error).show(); });
	return resultado;
};

TituloService.prototype.eliminarTitulo = function(titulo, func) {
	var resultado;
	
	this.ajax("eliminarTitulo", { titulo: JSON.stringify(titulo), idLista:idLista } , 
			  function (ret) { func(ret);                                         }, 
			  function (ret) { $("#errorEditForm").text(ret.error).show(); });
	return resultado;
};

TituloService.prototype.cambioMultipleTitulo = function(titulo, cambio, ids, func) {
	var resultado;		
	this.ajax("cambioMultipleTitulo", { operacion: cambio, ids: JSON.stringify(ids), titulo: JSON.stringify(titulo), idLista:idLista } , 
			  function (ret) { func(ret);                                         }, 
			  function (ret) { $("#"+cambio+"Label").text(ret.error).show(); });
	return resultado;
};

//service boton guardar
TituloService.prototype.guardarCambios = function(func) {
	this.ajax("guardarCambiosPermanente", {} ,
			function (ret) { showMessage("Los datos se guardaron de manera correcta");
							 if(ret.error == null)
							    func(); 
						   }, 
			function (ret) { showError(ret.error);
    });
	
};

TituloService.prototype.descargarArchivo = function(idLista) {
	var url = contextPath +'/contrato/transaccion/titulo/descarga.action?idLista=' + idLista;
    window.open(url);
};

TituloService.prototype.descargarArchivoErrores = function() {
	var _url = contextPath +'/contrato/transaccion/titulo/descargaErrores.action';
	
	$.ajax({
		url : _url,
		type : 'post',
		async : false,
		dataType  : 'html',
		success : function(ret) {
			window.open(_url);
		},
		'error' : function(jqXHR, textStatus, errorThrown) {
			showError("Ocurrio un error");
		}
	});
};

TituloService.prototype.guardarSeriesAuto = function(item,func) {	
	this.ajax("seriesAutomaticoTitulo", { titulo: JSON.stringify(item), idLista:idLista } , 
			  function (ret) { func(ret);                                         }, 
			  function (ret) { $("#errorEditForm").text(ret.error).show(); });
};

TituloService.prototype.obtenerCatalogos = function() {
	var p;
	this.ajax("obtenerCatalogos", { } , function (ret) { p= ret; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.buscarListas = function() {
	var p;
	this.ajax("buscarListas", { } , function (ret) { p= ret; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.listarTitulosEnLista = function(idLista) {
	var resultado;
	this.ajax("listadoTitulosEnLista", {idLista:idLista} , 
			  function (ret) { resultado = ret.titulos;  }, 
			  function (ret) { showError(ret.error); });
	return resultado;
};

TituloService.prototype.ajax = function(action, data, success, error) {
	$.ajax({
		url : contextPath +'/contrato/transaccion/titulo/'+action+'.action',
		type : "post",
		data : data,
		async : false,
		success : function (ret)
		{
			if(ret.error == '' || ret.error == null)
			{
				success(ret);
			}
			else{
				error(ret);
			}
		},
		error : function ( jqXHR,  textStatus,  errorThrown )
		{
			showError("Ocurri\u00F3 un error");
		}
	});
};