var perfil;

$(document).ready(function(){

	perfil     = new PerfilController();	
	inicializarBotones();
	inicializarCatalogo();
	perfil.ejecutarPerfil(parseInt($("#pmn").val()));
	
});

function inicializarCatalogo(){	
	$.post( contextPath + '/factura/listado/getEstudiosListadoFact')
	 .done(function( response ) 
	  {
		 if(response.msgError != null){        		        		
     		showError(response.msgError);
     	 }
     	 else{
     		$('#estudioSe').append('<option value="0">Todos</option>');
     		for (var i=0; i<response.estudios.length; i++){     	 	   
      	       var valor = response.estudios[i].idEstudio;
     	       var texto = response.estudios[i].descripcionEstudio;     	       
     	       var opcion = '<option value="'+ valor +'">'+ texto +'</option>';     	       
     	       $('#estudioSe').append(opcion);
     		}         	    
     	 }
	 });	
}

function inicializarBotones(){
	
    $("#buscar").click(function()  
    {
    	getDatos(); 
    });
    
    $("#nuevo").click(function()  
    {
		if(validaPermisos('57')){
			enviarOperacion(1, 0);	
		}
    });
    
    $('#nuevo').prop("disabled", true);
 }
 
 function validaPermisos(pmn){
 	var perfilService = new PerfilService();
 	var data = perfilService.obtenerPermisos(pmn);
 	if(data.permisoSi === 0){
 		showError("No se tienen permisos para realizar esta acci&oacute;n.");
 		return false;
 	} else {
 		return true;
 	}
 }

function getDatos(){	
	var estudios = [];
	var estudioVal = $("#estudioSe").val();
	var i = 0;
	
	if(estudioVal == "0")
	{		
		$("#estudioSe option").each(function()
		{
			var estudio = { idEstudio : $(this).val(), descripcionEstudio : "" }
			estudios[i] = estudio;
			i++;
		});
	}
	else{
		var estudio = { idEstudio : estudioVal, descripcionEstudio : "" }
		estudios[i] = estudio;
	}			
	
	var factura;
	if($("#numeroFact").val() == "")
		factura = null;
	else
		factura = $("#numeroFact").val();
			
	$.post( contextPath + '/factura/listado/getListadoFacturacion', 
			{ jsonRequest: JSON.stringify(estudios) , numeroFact : factura }
		  )
	 .done(function( response ) 
	  {
		 if(response.msgError != null){        		        		
     		showError(response.msgError);
     	 }
     	 else{
     		var contenedor = "contenedor";
        	var tabla = "listadoFacturas";
        	
        	$('#'+contenedor).empty();
            $('#'+tabla).remove();      
     		crearTabla(contenedor,tabla,response.listadoFacturas);
     	 }
	 });	
}

function crearTabla(contenedor,tabla,dataSet){
	
	var datos = [];
	for(var i=0; i < dataSet.length; i++)
	{
		var fila = [];
		fila[0] = dataSet[i].numero;
		fila[1] = dataSet[i].estudio;
		fila[2] = dataSet[i].fecha;		
		fila[3] = dataSet[i].approved;
		fila[4] = dataSet[i].sap;
		fila[5] = dataSet[i].amount;
		fila[6] = dataSet[i].facturaSap;
		fila[7] = dataSet[i].documentoSap;
		fila[8] = dataSet[i].acciones;
		fila[9] = dataSet[i].idFactura;
		datos[i] = fila;		
	}
		
	var nombreTabla = tabla;		
	$("#"+contenedor).append($("<table/>").addClass('table table-striped table-hover').attr('id',nombreTabla));	
	$("#"+nombreTabla).append($("<thead/>").addClass('encabezado'));
	
	var table = $('#'+nombreTabla).DataTable( {		
        data: datos,
        columns: [
            { title: "N\u00FAmero"     },
            { title: "Estudio"    },
            { title: "Fecha"      },            
            { title: "Approved"   },
            { title: "SAP"        },
            { title: "Amount"     },
            { title: "Factura SAP"     },
            { title: "Documento SAP"     },
            { title: "Acciones"   } ],
        columnDefs: [ {
            "targets": -1,
            "data"   : null,
            "defaultContent": "" }, { className: "dt-right", "targets": [5] } ],
	    createdRow: function ( row, data, index ) {
             	    		    	
	    	$('td', row).eq(3).empty();
	    	$('td', row).eq(4).empty();
	    	
	    	var html;
	    		
	    	html = agregarIconCheck( data[3] );
	    	$('td', row).eq(3).append(html);
	    	
	    	html = agregarIconCheck( data[4] );
	    	$('td', row).eq(4).append(html);
	    	
	    	if ( data[3] == "1") 
	    		 $('td', row).eq(8).append("<a href='#' onclick='enviarOperacion(3,"+ data[9] +")' style='color:#CB2C25'>Ver</a>");	    			    	 
	    	else              
	    		$('td', row).eq(8).append("<a href='#' onclick='enviarOperacion(2,"+ data[9] +")' style='color:#CB2C25'>Editar</a>  "+ 
		                                  "<a href='#' onclick='enviarOperacion(4,"+ data[9] +")' style='color:#CB2C25'>Eliminar</a>");
	    	    	    	   	    		    	   	    	  
       },
	   language: {
	        "sProcessing":    "Procesando...",
	        "sLengthMenu":    "Mostrar _MENU_ registros",
	        "sZeroRecords":   "No se encontraron resultados",
	        "sEmptyTable":    "No hay contratos que satisfagan los criterios de b\u00FAsqueda.",
	        "sInfo":          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
	        "sInfoEmpty":     "Mostrando registros del 0 al 0 de un total de 0 registros",
	        "sInfoFiltered":  "(filtrado de un total de _MAX_ registros)",
	        "sInfoPostFix":   "",	        
	        "oPaginate": {
	            "sFirst":    "Primero",
	            "sLast":    "Último",
	            "sNext":    "Siguiente",
	            "sPrevious": "Anterior"
	        },	     
	    },
	    bFilter: false, bInfo: false, "bSort": false,              
	    scrollX: true
    } );
	table.columns.adjust().draw();	
	
	$('table tbody tr').find("td:nth-child(8)").find("a:first").hide();						   			
	$('table tbody tr').find("td:nth-child(8)").find("a:last").hide();	
	perfil.ejecutarPerfil(parseInt($("#pmn").val()));
}

function agregarIconCheck(valor){
      html = "";	  
	  if(valor == "1")
		  html = "<i class='fa fa-check'>";
	  return html;
}
       
function enviarOperacion(operacion, factura){	

	var idFactura = factura;
	var pmn = 57;
	
	if(operacion == "1" || operacion == "2" || operacion == "3") //1 agregar, 2 editar, 3 ver
	{	
		pmn = operacion == "2" ? 58 : 57;
		var urlAction = contextPath + '/factura/listado/operacionListado?operacion=' + operacion + '&idFactura=' + idFactura +"&pmn="+ pmn + "&pmnReturn=" + 52; 
		window.location.href = urlAction;
	}
	else if(operacion == "4")
	{    		    		
		$.post( contextPath + '/factura/listado/operacionListado', 
    			{ idFactura: idFactura , operacion : operacion }
    		  )
    	 .done(function( response ) 
    	  {    		     		     		    		     		 
    		 if(response.msgError != null)        		        		
         		showError(response.msgError);             	 
         	 else
         	 {
         		showMessage(response.msgExito);
         		getDatos();         		
         	 }
    	 });	        	
	}		
}