function callActionAjax(actionRoute, jsonActionParameter, functionProcessor) {

	$.ajax({
		url: contextPath + actionRoute,
		type: 'POST',
		data: jsonActionParameter,
		dataType: "json",
		success: function(response) {
			functionProcessor(response);
		},
		error: function(jqXhr, textStatus, errorThrown) {
		}
	});

}

function validaNuloUndefinido(variable) {

	if ((variable === null && typeof variable === "object") ||
		(variable === undefined && typeof variable === "undefined") ||
		(variable === "" && typeof variable === "string")
	) {
		return 0;
	} else {
		return variable;
	}
}

function validaParametrosEntrada(estudioEleccion, mesEleccion) {
	var estudioNoValida = validaNuloUndefinido(estudioEleccion);
	var mesNoValida = validaNuloUndefinido(mesEleccion);
	var fechaValida = validaFechaMesAnio(mesEleccion);

	if (estudioNoValida == 0 || mesNoValida == 0 || fechaValida == 0)
		return 0;
	return 1;
}


$(document).ready(function() {

	$('#fecha').datepicker({ dateFormat: 'mm/yy' });


	$('#consultaReporte').click(function() {

		var estudioEleccion = $('#estudioEleccion').val();
		var mesEleccion = $('#fecha').val();

		if (validaParametrosEntrada(estudioEleccion, mesEleccion) != 0) {
			generaReporteAmortizacion(estudioEleccion, mesEleccion);
		} else {
			showError("No se ha seleccionado un valor v\u00E1lido de estudio y/o fecha o la fecha seleccionada no tiene el formato adecuado MM/YYYY");
		}
	});


	$('#generaExcelReporte').click(function() {

		var estudioEleccion = $('#estudioEleccion').val();
		var mesEleccion = $('#fecha').val();

		if (validaParametrosEntrada(estudioEleccion, mesEleccion) != 0) {

			var url = contextPath + '/reporte/amortizacion/excelAmortizacion.action?idEstudio=' + $("#estudioEleccion").val() + '&fecha=' + $("#fecha").val();
			window.open(url);

		} else {
			showError("No se ha seleccionado un valor v\u00E1lido de estudio y/o fecha o la fecha seleccionada no tiene el formato adecuado MM/YYYY");
		}

	});

});


function validaFechaMesAnio(fecha) {
	var fecha_valida = 0;
	fecha = '01/' + fecha;
	try {
		testdate = $.datepicker.parseDate('dd/mm/yy', fecha);
		fecha_valida = 1;
	} catch (e) {
		fecha_valida = 0;
	}
	return fecha_valida;
}


function generaReporteAmortizacion(estudio, fecha) {

	if (validaNuloUndefinido(estudio) == 0)
		estudio = null;

	if (validaNuloUndefinido(fecha) == 0)
		fecha = null;

	var jsonString = '{"idEstudio":' + estudio + ',"fecha": "' + fecha + '"}';
	var stringJson = JSON.parse(jsonString);

	callActionAjax("/reporte/amortizacion/cargaInicialReporteSAP", stringJson, procesaDatosReporte);
}

function generaDetalleReporteAmortizacionContrato(contrato, fecha) {

	if (validaNuloUndefinido(contrato) == 0)
		contrato = null;

	if (validaNuloUndefinido(fecha) == 0)
		fecha = null;

	var jsonString = '{"idContrato":' + contrato + ',"fecha": "' + fecha + '"}';
	var stringJson = JSON.parse(jsonString);
	var tamanofilasTitulos = $('tr.' + contrato + 'collapsed').length;

	if (tamanofilasTitulos == 0)
		callActionAjax("/reporte/amortizacion/cargaTitulosMontoContratoSAP", stringJson, procesaDatosDetalleContrato);
}

function procesaDatosReporte(datos) {

	

	var nombreTabla = "reportePagoSuscriptor";
	var nombreTablaContenedor = "facturaDetalleContainerContainer";
	var nombreAppender = "tablaAmortizacionDetalle";


	var headerTablaRow = tituloReporte(nombreTabla, nombreTablaContenedor, datos.fechasRango);

	$('#' + nombreAppender).append(headerTablaRow);

	var totalesMontosContratosTamano = datos.totalesMontosContratos.length;

	var filaTotalesPorEstudio = detalleReporte(datos.totalesMontosEstudio);
	$('#' + nombreTabla + ' > tbody:last').append(filaTotalesPorEstudio);


	for (var i = 0; i < totalesMontosContratosTamano; i++) {
		var fila = detalleContratoReporte(datos.totalesMontosContratos[i]);
		$('#' + nombreTabla + ' > tbody:last').append(fila);

	}

	$('.header').click(function() {

		var separado = $(this).attr('id');
		var idContrato = obtenNSplitPorSeparador(separado, "rId", 1);
		var mesEleccion = $('#fecha').val();
		fHideShow(idContrato);

		if ($(this).attr('search') == '0') {
			$(this).attr('search', '1');
			generaDetalleReporteAmortizacionContrato(idContrato, mesEleccion);
		}

	});

}

function procesaDatosDetalleContrato(datos) {

	var idContrato = datos.idContrato;

	var totalesMontoTitulosTamano = datos.montosTitulos.length;

	for (var i = totalesMontoTitulosTamano - 1; i >= 0; i--) {
		var fila = detalleTitulosReporte(datos.montosTitulos[i], idContrato);
		$('#rId' + idContrato).after(fila);
	}

	$('#rId' + idContrato).attr('search', '0');
}


function tituloReporte(idNombreTabla, idNombreTablaContainer, fechas) {

	var fechasTamano = fechas.length;


	$('#' + idNombreTablaContainer).remove();

	var header = '<div id="' + idNombreTablaContainer + '" >' +
		'<table id="' + idNombreTabla + '" class="table table-striped table-hover">' +
		'<thead>' +
		'<tr class="encabezado" >' +
		'<th></th>';

	for (var i = 0; i < fechasTamano; i++) {
		header = header + '<th class="text-right"><div>' + fechas[i] + '</div></th>';
	}

	header = header + '<th><div>ACUMULADO</div></th>' +
		'</tr>' +
		'</thead>' +
		'<tbody>' +
		'</tbody>' +
		'</table>' +
		'</div>';

	return header;
}

function detalleReporte(objetoDetalle) {

	var reporteTotalesContratoTamano = objetoDetalle.montoMes.length;
	var montosPorMes = objetoDetalle.montoMes;

	var fila = '<tr class="danger">';

	fila = fila + '<td>' +
		'<div><h6><strong>' +
		objetoDetalle.descripcion +
		'</strong></h6></div>' +
		'</td>';

	for (var i = 0; i < reporteTotalesContratoTamano; i++) {

		var n = parseFloat(montosPorMes[i].monto);

		fila = fila + '<td class="text-right">' +
			'<div><h6><strong>' +
			"$ " + n.formatDLA() +
			'</strong></h6></div>' +
			'</td>';
	}

	fila = fila + '</tr>';

	return fila;
}

function detalleContratoReporte(objetoDetalle) {

	var reporteTotalesContratoTamano = objetoDetalle.montoMes.length;
	var montosPorMes = objetoDetalle.montoMes;

	var fila = '<tr id="rId' + objetoDetalle.id + '" class="header success" search="0">';

	fila = fila + '<td id="rId' + objetoDetalle.id + '-cId0" >' +
		'<div><h6><strong class="text-danger">' +
		objetoDetalle.descripcion +
		'</strong></h6></div>' +
		'</td>';

	for (var i = 0; i < reporteTotalesContratoTamano; i++) {

		var n = parseFloat(montosPorMes[i].monto);

		fila = fila + '<td id="rId' + objetoDetalle.id + '-cId' + (i + 1) + '" class="text-right" >' +
			'<div><h6><strong>' +
			"$ " + n.formatDLA() +
			'</strong></h6></div>' +
			'</td>';
	}

	fila = fila + '</tr>';

	return fila;
}

function detalleTitulosReporte(objetoDetalle, contrato) {

	var reporteTotalesContratoTamano = objetoDetalle.montoMes.length;
	var montosPorMes = objetoDetalle.montoMes;

	var fila = '<tr id="' + objetoDetalle.id + '" class="' + contrato + 'collapsed">';

	fila = fila + '<td>' +
		'<div><h6><strong class="text-info">' +
		objetoDetalle.descripcion +
		'</strong></h6></div>' +
		'</td>';

	for (var i = 0; i < reporteTotalesContratoTamano; i++) {

		var n = parseFloat(montosPorMes[i].monto);

		fila = fila + '<td  align="right">' +
			'<div><h6><strong>' +
			"$ " + n.formatDLA() +
			'</strong></h6></div>' +
			'</td>';
	}

	fila = fila + '</tr>';

	return fila;
}

function fHideShow(pnuId) {
	if ($("." + pnuId + "collapsed:visible").length > 0)
		$("." + pnuId + "collapsed").hide();
	else
		$("." + pnuId + "collapsed").show();
}


function obtenNSplitPorSeparador(cadena, separador, nOcurrencia) {
	var ocurrencias = cadena.split(separador);
	return ocurrencias[nOcurrencia];
}