
var reporteOveragesYPaymentsController = function($scope, $filter, utileriasService) {

	$scope.tipoReporte = null;
	$scope.tabla = null;
	$scope.header = null;
	$scope.columnCfg = null;
	$scope.estudios = [];
	$scope.estudio = null;
	$scope.noOcultos = [];
	$scope.muestraInformacion = null;

	var dateIni = moment().subtract(12, 'months').format('MM/YYYY');
	var dateFin = moment().subtract(1, 'months').format('MM/YYYY');

	$scope.fechaInicio = dateIni;
	$scope.fechaFin = dateFin;

	$('#mesInicial').datepicker({ dateFormat: 'mm/yy' });
	$('#mesFinal').datepicker({ dateFormat: 'mm/yy' });

	utileriasService.actionCall('/reporte/overagespayments/obtenerEstudios.action', {}).then(function(data) {

		if (data.errorMensaje != null)
			showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
		else {
			$scope.estudios = data.estudios;
		}
	},
		function(error) {
			showError("Ha ocurrido el siguiente error: " + error);
		});

	$scope.muestraReporte = function(fechaInicial, fechaFinal, tipoPago, idEstudio) {

		if (!fechaInicial)
			showError("Favor de elegir un rango inicial para el reporte");
		else if (!fechaFinal)
			showError("Favor de elegir un rango final para el reporte");
		else if (!tipoPago)
			showError("Favor de elegir un tipo de pago");
		else if (!idEstudio)
			showError("Favor de elegir un estudio");
		else
			if (moment(fechaInicial, 'MM/YYYY').isAfter(moment(fechaFinal, 'MM/YYYY')))
				showError("Fecha inicial mayor a fecha final");
			else
				$scope.generaReporte(fechaInicial, fechaFinal, tipoPago, idEstudio);

	}

	$scope.generaReporte = function(fechaInicial, fechaFinal, tipoPago, idEstudio) {

		


		var actionpath = null;
		var parametros = { fechaInicial: fechaInicial, fechaFinal: fechaFinal, tipoPago: tipoPago, claveReporte: 'ROP', idEstudio: idEstudio, validaEstatusCarga: $scope.validaEstatusCarga };

		var actionpath = '/reporte/overagespayments/obtenerDatosReporte.action';

		utileriasService.actionCall(actionpath, parametros).then(function(data) {
			if (data.errorMensaje != null) {
				showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
				$scope.muestraInformacion = false;
			}
			else {
				$scope.tabla = data.reporteVista.tabla;
				$scope.header = data.reporteVista.header;
				$scope.columnCfg = data.reporteVista.columnCfg;
				$scope.muestraInformacion = true;
				$scope.noOcultos.splice(0, $scope.noOcultos.length);

			}
		},
			function(error) {
				
				showError("Ha ocurrido el siguiente error: " + error);
				$scope.muestraInformacion = false;
			});


	}

	$scope.descargaReporte = function(fechaIni, fechaFin, tipoPago, claveReporte, idEstudio) {
		var url = contextPath + '/reporte/overagespayments/exportaReporte.action?fechaInicial=' + fechaIni + '&fechaFinal=' + fechaFin + '&tipoPago=' + tipoPago + '&claveReporte=' + claveReporte + '&idEstudio=' + idEstudio + '&validaEstatusCarga=' + $scope.validaEstatusCarga;

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }

	}

	$scope.imprime = function(idDivPrintArea, fechaIni, fechaFin) {

		$("#" + idDivPrintArea).printThis({
			importCSS: true,
			importStyle: true,
			header: "<h3 style='width: 950px; font-weight:bold;'><img style='padding-right: 50px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>REPORTE OVERAGES Y PAYMENTS PERIODO " + utileriasService.getMes(fechaIni) + " - " + utileriasService.getAnio(fechaIni) + " AL " + utileriasService.getMes(fechaFin) + " - " + utileriasService.getAnio(fechaFin) + "</h3>"

		});

	}

	$scope.mostrarColumna = function(columna) {
		if (bypassColumnaConfig(columna, ['ORDEN', 'TYPE_PAGO', 'NUMERO_CONTRATO']))
			return false;
		if (bypassColumnaConfig(columna, ['ASSET_NAME']))
			return true;
		if ($scope.columnCfg == null || $scope.columnCfg.length == 0)
			return true
		for (var i = 0; i < $scope.columnCfg.length; i++)
			if ($scope.columnCfg[i] == mapeoColumnaConfiguracion(columna))
				return true;
		return false;
	}

	function mapeoColumnaConfiguracion(columna) {
		if (/[M][0-9]*$/g.test(columna)) return 'MES';
		return columna;
	}

	function bypassColumnaConfig(columna, excepciones) {
		if ($.inArray(columna, excepciones) > -1) return true;
		return false;
	}

	$scope.ocultarFilas = function(id1, id2) {
		var idA = $filter('removeSpaces')(id1);
		var idB = $filter('removeSpaces')(id2);

		var index = $.inArray(idA + idB, $scope.noOcultos);
		if (index > -1)
			$scope.noOcultos.splice(index, 1);
		else
			$scope.noOcultos.push(idA + idB);

	}


	$scope.ocultaFila = function(id1, id2, id0) {
		var idA = $filter('removeSpaces')(id1);
		var idB = $filter('removeSpaces')(id2);

		if (id0 == 2) {
			if ($.inArray(idA + idB, $scope.noOcultos) > -1)
				return false;
			return true;
		}

		return false;
	}

	$scope.obtenEstilo = function(row, column, x, y, tlength) {

		var styles = {};

		if ((x + 1) == tlength)
			styles['text-align'] = "center";
		else if ($.inArray(column.cname, ['ASSET_NAME', 'CLASS']) > -1)
			styles['text-align'] = "left";
		else styles['text-align'] = "right";

		if ((x + 1) == tlength)
			styles['font-weight'] = "bold";

		return styles;
	}

	$scope.obtenFiltro = function(item, row, column, x, y, tlength) {

		if (!($.inArray(column.cname, ['ASSET_NAME', 'CLASS']) > -1))
			item = $filter('number')(item, 2);

		return item;
	};

	$scope.esLink = function(row, column, x, y, tlength) {
		return column.cname == 'ASSET_NAME' && row[0].valor == 1;
	};

	$scope.esStringVacio = function(valor) {
		return valor ? valor.trim().length == 0 : true;
	}

	$scope.cambioFecha = function() {
		$scope.muestraInformacion = false;
	}


}

registraController("reporteOveragesYPaymentsController", reporteOveragesYPaymentsController);
