$().ready(function() {
	colocaFechaFin();
});

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor) {

	$.ajax({
		url: contextPath + actionRoute,
		type: 'POST',
		data: jsonActionParameter,
		dataType: "json",
		success: function(response) {
			functionProcessor(response);
		},
		error: function(jqXhr, textStatus, errorThrown) {
			console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
		}
	});

}

function procesaDetalleContratos(jsonData) {
	var contratos = jsonData.detalleContratos;

	if (contratos.length > 0) {

		$("#campoContrato").prop("disabled", false);
		$('#campoContrato').find('option').remove();
		$("#campoContrato").append('<option value="">Todos</option>');
		$("#botonConsultar").prop("disabled", false);

		for (var i = 0; contratos.length; i++) {
			cnt = contratos[i];
			$("#campoContrato").append('<option value="' + cnt.idContrato + '">' + cnt.numeroContrato + '</option>');
		}

	} else {
		$("#campoContrato").prop("disabled", true);
		$("#botonConsultar").prop("disabled", true);
		$("#botonExportar").prop("disabled", true);
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: [], colModel: [], data: [], datatype: 'local' }).trigger('reloadGrid');
		showError("El estudio seleccionado no tiene contratos asociados");
	}

}

function llamaObtenerDetalleContratos() {
	var jsonString = '{"idEstudio" : "' + $("#campoEstudio").val() + '", "fechaInicio":"' + $("#campoFechaInicio").val() + '", "fechaFin":"' + $("#campoFechaFin").val() + '"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax("/reporte/reportePago/detalleContrato", stringJson, procesaDetalleContratos);
}

var infoReporte = [];

function procesaReportePrincipal(jsonData) {
	var colNamesVar = ['Concepto', 'dic', 'en', 'febr', 'mzo', 'abr', 'my', 'jun', 'jul', 'agt', 'sept', 'oct', 'nov', 'dic', 'Total'];
	var colModelVar = [{ name: 'concepto', index: 'concepto', width: 150, frozen: true, sortable: false },
	{ name: 'm1', index: 'm1', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm2', index: 'm2', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm3', index: 'm3', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm4', index: 'm4', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm5', index: 'm5', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm6', index: 'm6', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm7', index: 'm7', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm8', index: 'm8', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm9', index: 'm9', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm10', index: 'm10', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm11', index: 'm11', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm12', index: 'm12', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'm13', index: 'm13', width: 80, align: "right", formatter: "number", sortable: false },
	{ name: 'total', index: 'total', width: 80, align: "right", formatter: "number", sortable: false }];

	var colModelNames = ['concepto', 'm1', 'm2', 'm3', 'm4', 'm5', 'm6', 'm7', 'm8', 'm9', 'm10', 'm11', 'm12', 'm13', 'total'];

	var datos = jsonData.reporte;
	var header = jsonData.encabezado;

	var imarcar = 0;
	var porMarcar = [];
	var patron = /^[A-Z]{4}\d{5}[A-Z]$/;


	if (datos.length > 0) {

		for (var i = 0; i < datos.length; i++) {
			if (patron.test(datos[i].concepto))
				porMarcar[imarcar++] = (i + 1);
		}
		$("#botonExportar").prop("disabled", false);

		jQuery("#reporteTable").jqGrid({
			datatype: "local",
			colNames: colNamesVar,
			colModel: colModelVar,
			width: '1000',
			height: '300',
			rowNum: 999999,
			autowidth: false,
			shrinkToFit: false,
			multiselect: false,
			loadComplete: function() {
			}
		});

		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: colNamesVar, colModel: colModelVar, data: datos, datatype: 'local' }).trigger('reloadGrid');

		for (var i = 0; i < colModelNames.length; i++) {
			jQuery("#reporteTable").jqGrid('setLabel', colModelNames[i], header[i]);
		}

		jQuery("#reporteTable").jqGrid('setRowData', 1, false, 'totalContratoRowClass');

		for (var i = 0; i < porMarcar.length; i++) {
			jQuery("#reporteTable").jqGrid('setRowData', porMarcar[i], false, 'contratoRowClass');
		}

		jQuery("#reporteTable").jqGrid('setFrozenColumns');

		infoReporte = datos;

	} else {
		showError("El contrato seleccionado no tiene t\u00EDtulos asociados.");
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: colNamesVar, colModel: colModelVar, data: datos, datatype: 'local' }).trigger('reloadGrid');
		$("#botonExportar").prop("disabled", true);
	}

}

function colocaFechaFin() {

	var fechaInicio = new Date($("#campoFechaInicio").val());

	var cdia = '';
	var cmes = '';

	if (fechaInicio != null) {
		cmes = fechaInicio.getMonth() < 10 ? '0' : '';
		cdia = fechaInicio.getDate() < 10 ? '0' : '';
	}

	$("#campoFechaFin").val(cmes + (fechaInicio.getMonth() + 1) + '/' + cdia + fechaInicio.getDate() + '/' + (fechaInicio.getFullYear() + 1));
}

function llamaReporteInfoAction() {
	var jsonString = '{"idCon" : "' + $("#campoContrato").val() + '", "fechaInicio":"' + $("#campoFechaInicio").val() + '", "fechaFin":"' + $("#campoFechaFin").val() + '", "idEstudio":"' + $("#campoEstudio").val() + '"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax("/reporte/reportePago/reportePagoInfo", stringJson, procesaReportePrincipal);
}

function descargarReporteEnExcel() {
	var url = contextPath + '/reporte/reportePago/reportePagoExcel.action?idCon=' + $("#campoContrato").val() + '&idEstudio=' + $("#campoEstudio").val() + '&fechaInicio=' + $("#campoFechaInicio").val();
	window.open(url);
}