function PagosTxController() {
	this.grid = new PagosTxGrid();
	this.idFormEliminar = $("#idFormBusqueda").validate({});
	var me = this;
	$('#mes').datepicker({
		maxDate: '-1m',
		dateFormat: 'mm-yy',
		onClose: function(dateText, inst) {
			if (dateText != '') {
				$(this).datepicker('setDate', new Date(inst.currentYear, inst.currentMonth, 1));
				me.buscarPagos();
			}
		}
	});

	$("#divEnvioSAP").hide();
}

PagosTxController.prototype.buscarPagos = function() {
	if ($("#idFormBusqueda").valid()) {
		var items = [];
		this.ajax("buscaPagos", {
			"filtros.idEstudio": $("#estudio").val(),
			"filtros.mes": $("#mes").val(),
			"filtros.tipoTitulo": $("#tipoTitulo").val()
		}, function(ret) {
			items = ret.pagos;
			if (ret.pendientesPorNotificar == 'true') {
				$("#divEnvioSAP").show();
			}
			else {
				$("#divEnvioSAP").hide();
			}
		}, function(ret) {
			showError(ret.error);
		});
		this.grid.paint(items);
	}
	$("#botonExporta").show();
}

PagosTxController.prototype.ajax = function(method, data, success, error) {
	$.ajax({
		url: contextPath + '/reporte/pagoTransacciones/' + method + 'pagosTXAjax.action',
		type: "post",
		data: data,
		async: false,
		success: function(ret) {
			if (ret.error == '' || ret.error == null) {
				success(ret);
			}
			else {
				error(ret);
			}
		},
		error: function() {
			showError("Ocurri\u00F3 un error");
		}
	});
}

var pagosTxController;

$().ready(function() {
	pagosTxController = new PagosTxController();
});

PagosTxController.prototype.descargaReporte = function() {
	var excel = $("#dynTabledyn1").excelMapper({
		action: contextPath + '/excelTableReport/export.action',
		actionAttribute: "elements",
		rootRows: "rootElement"
	});

	$('#botonExporta').click(function() {
		excel.send();
	});
}