package com.mx.dla.dda.contrato.deal.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.deal.dtos.ContratoFilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.ContratoTypeDTO;
import com.mx.dla.dda.contrato.deal.dtos.DealDTO;
import com.mx.dla.dda.contrato.deal.dtos.FilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.TypeDTO;

public interface DealDAO {

	public List<TypeDTO> consultaDealTypes();

	public List<FilialDTO> consultaDealFiliales();

	public List<TypeDTO> consultaDealTypesByContrato(
			@Param("contratoType") ContratoTypeDTO param);

	public List<FilialDTO> consultaDealFilialesByContrato(
			@Param("contratoFilial") ContratoFilialDTO param);

	public void creaContratoTypeRelacion(ContratoTypeDTO param);

	public void eliminaContratoTypeRelacion(ContratoTypeDTO param);

	public void creaContratoFilialRelacion(ContratoFilialDTO param);

	public void eliminaContratoFilialRelacion(ContratoFilialDTO param);

	public void creaContratoDeal(DealDTO param);

	public void eliminaContratoDeal(DealDTO param);

	public void actualizaContratoDeal(DealDTO param);

	public DealDTO consultaContratoDeal(@Param("contratoDeal") DealDTO param);
	

}
