package com.mx.dla.dda.contrato.license.titulo.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.titulo.dtos.AmortizacionSAP;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;

public interface TituloFeeDmDAO {
		
	public void insertarTitulo(Titulo titulo);
	public Titulo buscarTitulo(Long idTituloCnt);
	public void actualizarTitulo(Titulo titulo);
	public void borrarTitulo (Long idTitulo);
	
	
	public Long cuentaTitulosPorListaYDescTitulo(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo, @Param("prefix") String prefix);
	public Double buscarTotalCostoTitulos(@Param("idContrato")Long idContrato, @Param("prefix") String prefix);
	public List<Titulo> buscaTotalesLista(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	public List<Titulo> buscaTotalesSerie(@Param("idLista")Long idLista , @Param("nombreUnico") String nombreUnico, @Param("prefix") String prefix);
	public List<Titulo> buscaDetalleSerie(@Param("idLista")Long idLista , @Param("nombreUnico") String nombreUnico, @Param("prefix") String prefix);
	public List<Titulo> buscaDetallePeliculas(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	public List<Titulo> buscaSerie1Capitulo(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	
	public void actualizarTituloVar(@Param("titulo")Titulo titulo, @Param("prefix")String prefix);
	Titulo buscarTitulosPorDescripcionEnLista(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo,
			@Param("temporada")String temporada,@Param("episodio")String episodio);
	
	public void borrarTitulosPorContrato (Long idContrato);
	
	public List<Titulo> buscarTitulosEnmiendaSincro(Long idCto);
	public List<Titulo> buscarTituloFiltroPaginado(Titulo titulo);
	

	public void  actualizarSubNum(SapNum sapNum);
	public List<AmortizacionSAP> buscaMaxSubNumByFechaAmort(@Param("idTituloCtoOrig")Long idTituloCtoOrig, @Param("anio") Integer anio);
	public List<SapNum> buscaSubNumDisminucion(Long idTituloCtoOrig);
	public void insertarSapSubnum(SapNum sapNum);
	public void borrarRegistroSAPNUM(@Param("idCnt")String idCnt);
	public SapNum getAumentosDisminXTitulo(Long idTituloCtoOrig);
	
	
	/*			
	void borrarTitulosPorLista (Long idLista);		
	List<Titulo> buscarTitulosPorLista(Long idLista);
	List<Titulo> buscarTitulosActivosEliminadosPorLista(Long idLista);
	List<Titulo> buscarTitulosPorIdTituloOrig( @Param("idTituloCntOrig")Long idTituloCntOrig,  @Param("prefix")String prefix);	
	List<Titulo> buscarTituloFiltro(Titulo titulo);
	List<Titulo> buscarTituloAgrupableFiltro(Titulo titulo);	
	void insertarCatTitulo(CatTitulo catTitulo);			
	CatTitulo buscarCatalogoTituloPorDesc(@Param("idEstudio")Long idEstudio,@Param("descTitulo")String descTitulo);
		
	List<Long> buscarIdsPorIdCarga(@Param("idCarga")String idCarga);	
	public String buscaMaxSubNum(Long idTituloCtoOrig);
					
	*/
}
