package com.mx.dla.dda.carga.transaccion.test;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.mx.dla.dda.carga.transaccion.daos.CargaTransaccionesDAO;
import com.mx.dla.dda.carga.transaccion.dtos.CargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.PrincipalCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowReporteCargaDTO;
import com.mx.dla.dda.common.test.BaseDaoTest;

public class CargaTransaccionesTest extends BaseDaoTest {

	@Autowired
	private CargaTransaccionesDAO cargaTransaccionesDAO;
	
	@Test(enabled=false)
	public void pruebaObtenCargaTransacciones(){
		List<CargaTransaccionesDTO> carga = cargaTransaccionesDAO.obtenCargaTransacciones("01/12/2017");
		
		if(carga != null)
			for(CargaTransaccionesDTO c:carga){
				logger.info("carga : [{}]", c);
			}
		
		PrincipalCargaTransaccionesDTO pcarga = new PrincipalCargaTransaccionesDTO();
		pcarga.setMesStr("01/12/2017");
		
		pcarga = cargaTransaccionesDAO.obtenerPrincipalCargaTransacciones(pcarga);
		
		logger.info("pcarga : [{}]", pcarga);
		
	}
	
	@Test(enabled = false)
	public void pruebaRegistraPrincipal(){
		PrincipalCargaTransaccionesDTO pcarga = new PrincipalCargaTransaccionesDTO();
		pcarga.setMesStr("01/12/2018");
		
		cargaTransaccionesDAO.registrarPrincipalCarga(pcarga);
		
		logger.info("pcarga : [{}]", pcarga);
	}
	
/*	@Test(enabled = false)
	public void pruebaObtenRowReporte() {
		List<RowReporteCargaDTO> reporte = cargaTransaccionesDAO.obtenRowReporte(1L);
		for(RowReporteCargaDTO c : reporte)
			logger.info("c : [{}]", c);
	} */
	
	
//	@Test
//	public void prubaFecha(){
//		Calendar cal = Calendar.getInstance();
//		cal.set(Calendar.DAY_OF_MONTH, 1);
//		cal.set(Calendar.MONTH, 11);
//		cal.set(Calendar.YEAR, 2017);
//		logger.info("Date : [{}]", cal.getTime());
//	}
}
