package com.mx.dla.admin.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.admin.daos.MenuDAO;
import com.mx.dla.admin.dtos.MenuDTO;
import com.mx.dla.admin.dtos.PermisoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Component
public class MenuBO extends BaseBO {
	
	@Autowired	
	private MenuDAO menuDAO;
	
	public List<MenuDTO> armarArbolMenus( List<MenuDTO> menus, String idPerfil )
	{		
		if( menus != null ){
			
			for( MenuDTO menu:menus ){
				
				if( !menu.getTipoMenu().equals("0") ){					
					
					//-- Tipo 0 => Permiso				
					String idMenu = menu.getIdMenu();					
					
					if( idMenu != null ){
						
						List<MenuDTO> hijos = menuDAO.consultarHijos( idMenu, idPerfil );						
						
						if( hijos != null ){
							hijos = this.armarArbolMenus( hijos, idPerfil );
							menu.setHijos( hijos );
						}
					}
				}
			}
		}
		
		return menus;
	}
	
	public List<PermisoDTO> obtenPermisosPerfil(String idPerfil) throws ResultMapException, SQLException, TransaccionException {
		
		List<PermisoDTO> permisos = null;
		
		try {
			permisos = menuDAO.obtenerPermisos(idPerfil);
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos.", e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos", e);
        }
		return permisos;
	}
	
}
