package com.mx.dla.dda.contrato.deal.bos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.deal.daos.DealDAO;
import com.mx.dla.dda.contrato.deal.dtos.ContratoFilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.ContratoTypeDTO;
import com.mx.dla.dda.contrato.deal.dtos.DealDTO;
import com.mx.dla.dda.contrato.deal.dtos.FilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.TypeDTO;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class DealBO extends BaseBO{

	@Autowired
	private DealDAO dealDAO;
	
	@Autowired
	private TerminosDAO feesDAO;

	public DealDTO cargaInformacionDeal(DealDTO dealParam) {

		DealDTO deal = new DealDTO();

		if (dealParam != null) {

			Long idContrato = dealParam.getIdContrato();

			DealDTO dealDTO = new DealDTO();
			ContratoFilialDTO contratoFilialDTO = new ContratoFilialDTO();
			ContratoTypeDTO contratoTypeDTO = new ContratoTypeDTO();

			dealDTO.setIdContrato(idContrato);
			contratoFilialDTO.setIdContrato(idContrato);
			contratoTypeDTO.setIdContrato(idContrato);
			
			
			ContratoConsultaDTO request = new ContratoConsultaDTO();
			request.setIdContrato(idContrato);		
			ContratoConsultaDTO contrato = feesDAO.consultaContrato(request);
			
			deal.setIdContrato(idContrato);
			deal.setLimitesLicencia(contrato.getLimitesLicencia());

			
			
			List<FilialDTO> filialesTotales = new ArrayList<FilialDTO>();
			filialesTotales = dealDAO.consultaDealFiliales();

			List<FilialDTO> filialesElegidas = new ArrayList<FilialDTO>();
			filialesElegidas = dealDAO
					.consultaDealFilialesByContrato(contratoFilialDTO);

			List<FilialDTO> filialesDisponibles = new ArrayList<FilialDTO>();

			Boolean fElegida = false;

			for (FilialDTO filial : safeList(filialesTotales)) {
				if (filial != null) {
					for (FilialDTO filialElegida : safeList(filialesElegidas)) {
						if (filialElegida != null)
							if (filial.getIdFilial().longValue() == filialElegida
									.getIdFilial().longValue())
								fElegida = true;
					}

					if (!fElegida)
						filialesDisponibles.add(filial);

					fElegida = false;
				}
			}

			List<TypeDTO> typesTotales = new ArrayList<TypeDTO>();
			typesTotales = dealDAO.consultaDealTypes();

			List<TypeDTO> typesElegidas = new ArrayList<TypeDTO>();
			typesElegidas = dealDAO
					.consultaDealTypesByContrato(contratoTypeDTO);

			List<TypeDTO> typesDisponibles = new ArrayList<TypeDTO>();

			Boolean tElegida = false;

			for (TypeDTO type : safeList(typesTotales)) {
				if (type != null) {
					for (TypeDTO typeElegida : safeList(typesElegidas)) {
						if (typeElegida != null)
							if (type.getIdType().longValue() == typeElegida
									.getIdType().longValue())
								tElegida = true;
					}

					if (!tElegida)
						typesDisponibles.add(type);

					tElegida = false;
				}
			}

			deal.setFilialesDisponibles(filialesDisponibles);
			deal.setFilialesElegidos(filialesElegidas);
			deal.setTypesDisponibles(typesDisponibles);
			deal.setTypesElegidos(typesElegidas);


		}

		return deal;

	}

	public void actualizaInformacionDeal(DealDTO dealParam) {

		if (dealParam != null) {
			

			
			ContratoConsultaDTO request = new ContratoConsultaDTO();
			request.setIdContrato(dealParam.getIdContrato());
			request.setLimitesLicencia(dealParam.getLimitesLicencia());	
			feesDAO.actualizaContratoLimitesLicencia(request);

			ContratoFilialDTO contratoFilialDTO = new ContratoFilialDTO();
			contratoFilialDTO.setIdContrato(dealParam.getIdContrato());

			ContratoTypeDTO contratoTypeDTO = new ContratoTypeDTO();
			contratoTypeDTO.setIdContrato(dealParam.getIdContrato());

			List<FilialDTO> filialesActuales = new ArrayList<FilialDTO>();
			filialesActuales = dealDAO
					.consultaDealFilialesByContrato(contratoFilialDTO);

			List<FilialDTO> filialesElegidas = new ArrayList<FilialDTO>();
			filialesElegidas = dealParam.getFilialesElegidos();

			for (FilialDTO filial : safeList(filialesActuales))
				if (filial != null) {
					contratoFilialDTO.setIdFilial(filial.getIdFilial());
					dealDAO.eliminaContratoFilialRelacion(contratoFilialDTO);
				}

			for (FilialDTO filial : safeList(filialesElegidas))
				if (filial != null) {
					contratoFilialDTO.setIdFilial(filial.getIdFilial());
					dealDAO.creaContratoFilialRelacion(contratoFilialDTO);
				}

			List<TypeDTO> typesActuales = new ArrayList<TypeDTO>();
			typesActuales = dealDAO
					.consultaDealTypesByContrato(contratoTypeDTO);

			List<TypeDTO> typesElegidas = new ArrayList<TypeDTO>();
			typesElegidas = dealParam.getTypesElegidos();

			for (TypeDTO type : safeList(typesActuales))
				if (type != null) {
					contratoTypeDTO.setIdType(type.getIdType());
					dealDAO.eliminaContratoTypeRelacion(contratoTypeDTO);
				}

			for (TypeDTO type : safeList(typesElegidas))
				if (type != null) {
					contratoTypeDTO.setIdType(type.getIdType());
					dealDAO.creaContratoTypeRelacion(contratoTypeDTO);
				}

		}

	}

	@SuppressWarnings("unchecked")
	public static <T> List<T> safeList(final List<T> other) {
		return other == null ? Collections.EMPTY_LIST : other;
	}

}
