package com.mx.dla.dda.contrato.fees.bos;

import java.io.IOException;
import java.util.List;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.FeesBonoRangoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoBonoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class FeesBonoBO extends BaseBO{
	
	@Autowired
	private FeesContratoDAO feesContratoDAO;
	
	public FeesPagoBonoDTO getBono(Long idContrato){				
		List<FeesBonoRangoDTO> pagoBonos = feesContratoDAO.getRangosBono(idContrato);
		FeesPagoBonoDTO bono = new FeesPagoBonoDTO();		
		bono.setRangos(pagoBonos);
		return bono;				   		   
	}
	
	public void guardarBono(String bonoRequest, Long idContrato) throws JsonParseException, JsonMappingException, IOException{
		this.eliminarBono(idContrato);		
		logger.debug("eliminar bono");
		if(bonoRequest != null && !bonoRequest.equals(""))
		{						
			ObjectMapper mapper = new ObjectMapper();
			FeesPagoBonoDTO bono = mapper.readValue(bonoRequest, FeesPagoBonoDTO.class);
			if(bono.getRangos() != null)
			{
				feesContratoDAO.guardarRangoBonoFlatALL(bono.getRangos(), idContrato); //Se guarda los rangos del bono
				logger.debug("guardar bono");
			}			   
		}		
	}
		
	public void eliminarBono(Long idContrato){								
		feesContratoDAO.eliminarBono(idContrato);
	}
	
	public void eliminarRangoBono(FeesContratoPagoDTO categoria){			
		feesContratoDAO.eliminarRangoFlatBonoByRango(categoria.getIdContrato(), categoria.getCategorias().get(0).getIdCategoria());																												
	}
}
