package com.mx.dla.dda.excelMapper.bos;

import java.util.ArrayList;
import java.util.List;

import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.SpreadsheetVersion;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;

@Component
public class ExcelMapperValidator {

	public void validateMapper(ExcelMapper mapper) throws ExcelMapperException {
		List<String>errors = new ArrayList<String>();
		if(mapper == null)
		{
			errors.add("Mapeo null");
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
		if(mapper.getId() == null)
		{
			errors.add("Id null");
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
		if(mapper.getRules() == null )
		{
			errors.add("Sin reglas");
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
		if(mapper.getRules().isEmpty() )
		{
			errors.add("Sin reglas");
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
		if(mapper.getParent() != null && "".equals(mapper.getParent()) )
		{
			errors.add("Sin mapeo padre");
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
		for(int i= 0 ; i<mapper.getRules().size();i++)
		{
			ExcelRule entry = mapper.getRules().get(i);
			if(entry.getAttribute() == null)
			{
				errors.add("Rule["+i+"]: campo atribute es obligatorio ");
			}
			if(entry.getColumn() == null || "".equals(entry.getColumn()) )
			{
				errors.add("Rule["+i+"]: Campo  column es obligatorio");
			}
			else
			{
				entry.setColumn(entry.getColumn().toUpperCase());
			}
			
			if ( !CellReference.isColumnWithnRange(entry.getColumn(), SpreadsheetVersion.EXCEL97))
			{
				errors.add("Rule["+i+"]: Columna fuera de rango (Columna maxima IV)");
			}
			
			if( (entry.getType()!= null && entry.getCustomTransform()!= null))
			{
				errors.add("Rule["+i+"]: Multiple tipos de dato (date,numerico,customTransform) ");
			}
		}
		if(!errors.isEmpty())
		{
			throw new ExcelMapperException(ExcelMapperException.ERROR_PARSING,errors);
		}
	}
}
