/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.bussines;

import com.dla.dda.domain.constants.CorreoAutorizacionTypes;
import com.dla.dda.domain.model.email.EmailModelVO;
import com.dla.dda.domain.model.email.MessageAttachment;
import com.dla.dda.domain.model.request.EmailAutorizacionRequest;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.utils.email.client.EmailService;
import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.stereotype.Service;

@Service
public class ProyectoAutorizacionCorreoBussines {
    @Qualifier(value="autorizacionEmailAviso")
    @Autowired
    private EmailService serviceAviso;
    @Qualifier(value="autorizacionEmailNotificacion")
    @Autowired
    private EmailService serviceNotificacion;
    @Qualifier(value="autorizacionEmailReporte")
    @Autowired
    private EmailService serviceReporte;
    @Qualifier(value="dlaEmailService")
    @Autowired
    private EmailService service;
    private static Logger logger = LoggerFactory.getLogger(ProyectoAutorizacionCorreoBussines.class);

    public EmailResponse enviaCorreo(EmailAutorizacionRequest request, InputStream attachment) {
        EmailResponse response = new EmailResponse();
        response.setRespuesta("true");
        EmailModelVO model = new EmailModelVO();
        try {
            if (attachment != null) {
                byte[] targetArray = new byte[attachment.available()];
                attachment.read(targetArray);
                request.setContentType(request.getContentType());
                request.setIos((InputStreamSource)new ByteArrayResource(targetArray));
                attachment.close();
            }
            model.setRequest((EmailRequest)request);
            MessageAttachment messageAttachment = new MessageAttachment();
            messageAttachment.setToAddres(request.getDestinatarios());
            messageAttachment.setSubject(request.getSubject());
            messageAttachment.setFromAdddres(request.getUserName());
            messageAttachment.setAttachmentFilename(request.getAttachmentFilename());
            messageAttachment.setContentType(request.getContentType());
            messageAttachment.setIos(request.getIos());
            this.sendMessage(model, messageAttachment);
        }
        catch (Exception e) {
            logger.error("Error envio correo:  [{}]", (Throwable)e);
            response.setRespuesta("false");
        }
        return response;
    }

    private void sendMessage(EmailModelVO modeloCorreo, MessageAttachment attachment) {
        CorreoAutorizacionTypes tipoCorreo = ((EmailAutorizacionRequest)modeloCorreo.getRequest()).getTipoCorreo();
        switch (tipoCorreo) {
            case AVISO: {
                logger.debug("AVISO");
                this.serviceAviso.sendMessage((Serializable)modeloCorreo, attachment);
                break;
            }
            case NOTIFICACION: {
                logger.debug("NOTIFICACION");
                this.serviceNotificacion.sendMessage((Serializable)modeloCorreo, attachment);
                break;
            }
            case REPORTE: {
                logger.debug("REPORTE");
                this.serviceReporte.sendMessage((Serializable)modeloCorreo, attachment);
                break;
            }
            default: {
                logger.debug("DEFAULT DESDE DLA");
                this.service.sendMessage((Serializable)modeloCorreo, attachment);
            }
        }
    }
}

