/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.services;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.domain.model.UserInfo;
import com.dla.dda.domain.model.request.SecurityRequest;
import com.dla.dda.domain.model.response.SecurityResponse;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.services.AccesosArea;
import com.dla.dda.services.EstudiosService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SecurityService {
    @Autowired
    private BaseDAO dao;
    private static Logger logger = LoggerFactory.getLogger(EstudiosService.class);

    public SecurityResponse login(SecurityRequest request) throws DLAIntegrationException {
        String username = request.getUser();
        String password = request.getPassword();
        Type[] types = new Type[]{StringType.INSTANCE};
        Object[] params = new Object[types.length];
        params[0] = username;
        SecurityResponse response = new SecurityResponse();
        try {
            List rawResult = this.dao.findListByQuery("userExistDLA", params, types, Object[].class);
            if (rawResult == null || rawResult.size() == 0) {
                logger.error("Usuario no existe [{}]", (Object)username);
                response.setEnabled(Boolean.FALSE);
                response.setDetail("Usuario No existe");
                return response;
            }
            Object[] result = (Object[])rawResult.get(0);
            String expediente = (String)result[0];
            String pass = (String)result[1];
            String idArea = (String)result[3];
            String area = (String)result[4];
            String nombre = (String)result[5];
            String empresa = (String)result[6];
            String email = (String)result[7];
            UserInfo userInfo = new UserInfo();
            userInfo.setArea(area);
            userInfo.setEmail(email);
            userInfo.setEmpresa(empresa);
            userInfo.setNombreCompleto(nombre);
            userInfo.setUsername(username);
            if (!pass.equals(password)) {
                logger.error("Password no valido [{}] [{}]", (Object)username, (Object)password);
                response.setEnabled(Boolean.FALSE);
                response.setDetail("Password no valido");
                return response;
            }
            Integer value = result[1] != null ? ((BigDecimal)result[2]).intValue() : 0;
            Boolean enabled = value == 1;
            List<String> accesos = AccesosArea.from(new Integer(idArea)).getAccesos();
            response.setUsername(expediente);
            response.setEnabled(enabled);
            response.setPerfil(accesos);
            response.setUser(userInfo);
        }
        catch (IOException e) {
            logger.error("Error al Autenticar [{}] [{}] [{}]", new Object[]{username, password, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }

    public SecurityResponse findPerfil(SecurityRequest request) throws DLAIntegrationException {
        String username = request.getUser();
        Type[] types = new Type[]{StringType.INSTANCE};
        Object[] params = new Object[types.length];
        params[0] = username;
        SecurityResponse response = new SecurityResponse();
        try {
            List rawResult = this.dao.findListByQuery("findPerfilByUsername", params, types, Object[].class);
            ArrayList<String> perfiles = new ArrayList<String>();
            for (Object[] result : rawResult) {
                String perfil = (String)result[1];
                perfiles.add(perfil);
            }
            response.setPerfil(perfiles);
        }
        catch (IOException e) {
            logger.error("Error al Obtener perfiles [{}] [{}]", new Object[]{username, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }
}

