package com.dla.dda.persistence.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "DDA_T_WF_SEGUIMIENTO")
public class DdaTWfSeguimiento implements Serializable {

	private static final long serialVersionUID = 1L;

	private Long idWfSeg;
	private Long idContrato;
	private Integer idPasoWf;
	private Date fecha1;
	private Date fecha2;
	private Date fecha3;
	private Integer estaAutorizado;

	public DdaTWfSeguimiento() {

	}

	public DdaTWfSeguimiento(Long idWfSeg) {
		this.idWfSeg = idWfSeg;
	}

	public DdaTWfSeguimiento(Long idWfSeg, Long idContrato, Integer idPasoWf, Date fecha1, Date fecha2, Date fecha3,
			Integer estaAutorizado) {
		this.idWfSeg = idWfSeg;
		this.idContrato = idContrato;
		this.idPasoWf = idPasoWf;
		this.fecha1 = fecha1;
		this.fecha2 = fecha2;
		this.fecha3 = fecha3;
		this.estaAutorizado = estaAutorizado;
	}

	@Id
	@Column(name = "ID_WF_SEG", unique = true, nullable = false, precision = 38, scale = 0)
	public Long getIdWfSeg() {
		return idWfSeg;
	}

	public void setIdWfSeg(Long idWfSeg) {
		this.idWfSeg = idWfSeg;
	}

	@Column(name = "ID_CONTRATO", unique = false, nullable = true, precision = 38, scale = 0)
	public Long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	@Column(name = "ID_PASO_WF", unique = false, nullable = true, precision = 5, scale = 0)
	public Integer getIdPasoWf() {
		return idPasoWf;
	}

	public void setIdPasoWf(Integer idPasoWf) {
		this.idPasoWf = idPasoWf;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="FECHA_1RO", columnDefinition="DATE")
	public Date getFecha1() {
		return fecha1;
	}

	public void setFecha1(Date fecha1) {
		this.fecha1 = fecha1;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="FECHA_2DO", columnDefinition="DATE")
	public Date getFecha2() {
		return fecha2;
	}

	public void setFecha2(Date fecha2) {
		this.fecha2 = fecha2;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="FECHA_3RO", columnDefinition="DATE")
	public Date getFecha3() {
		return fecha3;
	}

	public void setFecha3(Date fecha3) {
		this.fecha3 = fecha3;
	}

	@Column(name = "ESTA_AUTORIZADO", unique = false, nullable = true, precision = 1, scale = 0)
	public Integer getEstaAutorizado() {
		return estaAutorizado;
	}

	public void setEstaAutorizado(Integer estaAutorizado) {
		this.estaAutorizado = estaAutorizado;
	}

	@Override
	public String toString() {
		return "DdaTWfSeguimiento [idWfSeg=" + idWfSeg + ", idContrato=" + idContrato + ", idPasoWf=" + idPasoWf
				+ ", fecha1=" + fecha1 + ", fecha2=" + fecha2 + ", fecha3=" + fecha3 + ", estaAutorizado="
				+ estaAutorizado + "]";
	}

}
