package com.dla.dda.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public enum AccesosArea {
	
	ADQUISICIONES(1)   { List<String> getAccesos() { return Arrays.asList("Estudios", "Suscriptores", "Apartados", "Proyectos", "Proyecciones", "Reporte"); } },
	LEGAL(2)  { List<String> getAccesos() { return Arrays.asList("Estudios", "Suscriptores", "Apartados", "Proyectos", "Proyecciones", "Reporte"); } },
	FINANZAS(3)  { List<String> getAccesos() { return Arrays.asList("Estudios", "Suscriptores", "Apartados", "Proyectos", "Proyecciones", "Autorizacion", "Reporte"); } },
	PROGRAMACION(4) { List<String> getAccesos() { return new ArrayList<String>(); } },
	DIRECCION(5) { List<String> getAccesos() { return Arrays.asList("Estudios", "Suscriptores", "Apartados", "Proyectos", "Proyecciones", "Autorizacion", "Reporte" ); } };
	
	private int id;

	AccesosArea(int id) {
		this.id = id;
	}

	abstract List<String> getAccesos();

	public int toInt() {
		return this.id;
	}

	public static AccesosArea from(int id) {

		AccesosArea[] areas = AccesosArea.values();

		for (AccesosArea area : areas) {
			if (area.toInt() == id)
				return area;
		}

		return null;
	}

}
