package com.dla.dda.utils.test.client;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import com.dla.dda.utils.rest.client.IRestClient;
import com.dla.dda.utils.test.json.dto.DTOrdenInterna;
import com.dla.dda.utils.test.json.dto.OrdenesInternasDTO;

/**
 * @see Prueba unitaria para invocar el Rest Service de amortizacion
 * @author montieln
 *
 */
@ContextConfiguration(locations = { "classpath:rest-test-context.xml" })
public class RestClientTest extends AbstractTestNGSpringContextTests {

	private Logger logger = LoggerFactory.getLogger(RestClientTest.class);

	@Qualifier("amortizacionService")
	@Autowired
	private IRestClient amortizacionService;

	@Test(enabled = false)
	public void getOrdenesInternasTest() throws IOException {

		logger.info("Ordenes Internas");

		DTOrdenInterna request = new DTOrdenInterna();

		OrdenesInternasDTO response = amortizacionService.post(request, OrdenesInternasDTO.class);

		logger.info("response [{}]", response);

	}

}
