/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

public class HttpsURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static boolean weblogicWarned;
    SSLSocketFactory socketFactory;
    int lastTlsHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection createConnection(TLSClientParameters tlsClientParameters, java.net.Proxy proxy, URL url) throws IOException {
        HttpURLConnection connection;
        block8: {
            connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            if (HTTPS_URL_PROTOCOL_ID.equals(url.getProtocol())) {
                if (tlsClientParameters == null) {
                    tlsClientParameters = new TLSClientParameters();
                }
                Exception ex = null;
                try {
                    this.decorateWithTLS(tlsClientParameters, connection);
                }
                catch (Exception e) {
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block8;
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioException = new IOException("Error while initializing secure socket");
                    ioException.initCause(ex);
                    throw ioException;
                }
            }
        }
        return connection;
    }

    protected synchronized void decorateWithTLS(TLSClientParameters tlsClientParameters, HttpURLConnection connection) throws GeneralSecurityException {
        int hash = tlsClientParameters.hashCode();
        if (hash != this.lastTlsHash) {
            this.lastTlsHash = hash;
            this.socketFactory = null;
        }
        if (tlsClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        } else if (tlsClientParameters.getSSLSocketFactory() != null) {
            this.socketFactory = tlsClientParameters.getSSLSocketFactory();
        } else if (this.socketFactory == null) {
            SSLContext ctx = SSLUtils.getSSLContext((TLSParameterBase)tlsClientParameters);
            String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude((List)tlsClientParameters.getCipherSuites(), (FiltersType)tlsClientParameters.getCipherSuitesFilter(), (String[])ctx.getSocketFactory().getDefaultCipherSuites(), (String[])org.apache.cxf.configuration.jsse.SSLUtils.getSupportedCipherSuites((SSLContext)ctx), (Logger)LOG);
            String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : "TLS";
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, protocol);
            this.lastTlsHash = tlsClientParameters.hashCode();
        }
        HostnameVerifier verifier = SSLUtils.getHostnameVerifier(tlsClientParameters);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)connection;
            conn.setHostnameVerifier(verifier);
            conn.setSSLSocketFactory(this.socketFactory);
        } else {
            try {
                Method method = connection.getClass().getMethod("getHostnameVerifier", new Class[0]);
                ReflectionInvokationHandler handler = new ReflectionInvokationHandler(verifier){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        try {
                            return super.invoke(proxy, method, args);
                        }
                        catch (Exception ex) {
                            return true;
                        }
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
                method = connection.getClass().getMethod("setHostnameVerifier", method.getReturnType());
                method.invoke((Object)connection, proxy);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Method getSSLSocketFactory = connection.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                Method setSSLSocketFactory = connection.getClass().getMethod("setSSLSocketFactory", getSSLSocketFactory.getReturnType());
                if (getSSLSocketFactory.getReturnType().isInstance(this.socketFactory)) {
                    setSSLSocketFactory.invoke((Object)connection, this.socketFactory);
                } else {
                    Constructor<?> c = getSSLSocketFactory.getReturnType().getDeclaredConstructor(SSLSocketFactory.class);
                    ReflectionUtil.setAccessible(c);
                    setSSLSocketFactory.invoke((Object)connection, c.newInstance(this.socketFactory));
                }
            }
            catch (Exception ex) {
                if (connection.getClass().getName().contains("weblogic")) {
                    if (!weblogicWarned) {
                        weblogicWarned = true;
                        LOG.warning("Could not configure SSLSocketFactory on Weblogic.   Use the Weblogic control panel to configure the SSL settings.");
                    }
                    return;
                }
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), ex);
            }
        }
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }
}

