/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.utils.rest.client;

import com.dla.dda.utils.json.JsonConverter;
import com.dla.dda.utils.rest.client.IRestClient;
import java.io.IOException;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.client.WebClient;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServiceClient
implements IRestClient {
    private static Logger logger = LoggerFactory.getLogger(RestServiceClient.class);
    private String uri;
    protected WebClient jsonClient;

    public void initialize() {
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        providers.add(new JacksonJsonProvider());
        logger.info("Rest Service Client to [{}]", (Object)this.uri);
        this.jsonClient = WebClient.create((String)this.uri, providers);
        this.jsonClient.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.jsonClient.type(MediaType.APPLICATION_JSON_TYPE);
        this.jsonClient.header("Content-Type", new Object[]{MediaType.APPLICATION_JSON_TYPE});
    }

    @Override
    public <Response, Request> Response post(String path, Request request, Class<Response> responseClass) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("POST:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        this.jsonClient.path((Object)path);
        return (Response)this.jsonClient.post((Object)json, responseClass);
    }

    @Override
    public <Response, Request> Response post(Request request, Class<Response> responseClass) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("POST:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        return (Response)this.jsonClient.post((Object)json, responseClass);
    }

    @Override
    public <Response, Request> Response post(String request, Class<Response> responseClass) throws IOException {
        logger.debug("POST:[{}]", (Object)request);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        return (Response)this.jsonClient.post((Object)request, responseClass);
    }

    @Override
    public <Response, Request> Response put(String path, Request request, Class<Response> responseClass) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("PUT:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        this.jsonClient.path((Object)path);
        return (Response)this.jsonClient.put((Object)json);
    }

    @Deprecated
    public <Request> void delete(String path, Request request) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("DELETE:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        this.jsonClient.path((Object)path);
        this.jsonClient.delete();
    }

    @Deprecated
    public <Response, Request> Response get(String path, Request request, Class<Response> responseClass) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("GET:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        this.jsonClient.path((Object)path);
        return (Response)this.jsonClient.get(responseClass);
    }

    @Override
    public <Response, Request> Response put(Request request, Class<Response> responseClass) throws IOException {
        String json = null;
        try {
            json = JsonConverter.toJson(request);
        }
        catch (IOException e) {
            logger.error("Error to convert to Json : [{}]" + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("PUT:[{}]", (Object)json);
        logger.debug("URL:[{}]", (Object)this.jsonClient.getBaseURI());
        return (Response)this.jsonClient.put((Object)json);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

