package com.dla.dda.domain.model.request;

import java.io.Serializable;
import java.util.Set;

/**
 * @see Modelo Que representa el request para la validacion del presupuesto
 * @author montieln
 *
 */
public class PresupuestoRequest implements Serializable {

	private static final long serialVersionUID = 1L;

	private long contrato;
	private int anio;
	private String origenTitulos;
	private Boolean parcial;
	private Set<Long> idTitulos;

	public PresupuestoRequest() {
		super();
	}

	public PresupuestoRequest(long contrato, int anio, String origenTitulos) {
		super();
		this.contrato = contrato;
		this.anio = anio;
		this.origenTitulos = origenTitulos;
	}

	public long getContrato() {
		return contrato;
	}

	public void setContrato(long contrato) {
		this.contrato = contrato;
	}

	public int getAnio() {
		return anio;
	}

	public void setAnio(int anio) {
		this.anio = anio;
	}

	public String getOrigenTitulos() {
		return origenTitulos;
	}

	public void setOrigenTitulos(String origenTitulos) {
		this.origenTitulos = origenTitulos;
	}

	public Boolean getParcial() {
		return parcial;
	}

	public void setParcial(Boolean parcial) {
		this.parcial = parcial;
	}

	public Set<Long> getIdTitulos() {
		return idTitulos;
	}

	public void setIdTitulos(Set<Long> idTitulos) {
		this.idTitulos = idTitulos;
	}

	@Override
	public String toString() {
		return "PresupuestoRequest [contrato=" + contrato + ", anio=" + anio + ", origenTitulos=" + origenTitulos + "]";
	}

}
