package com.dla.dda.mdb;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.bussines.EmailBussines;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.utils.json.JsonConverter;
import com.dla.dda.utils.transaction.TransactionState;

/**
 * @see Servicio para procesar lo que nos llega de la queue para el
 *      procesamiento del correo
 * @author montieln
 *
 */
@Service
public class EmailMDP implements IProcessor {

	private static Logger logger = LoggerFactory.getLogger(EmailMDP.class);

	@Autowired
	private EmailBussines bussines;

	@Override
	public void process(String message) {

		TransactionState.Current().initialize();

		logger.info("Processing [{}]", message);

		// Paso 1. transformamos la cadena en formato json al objeto
		// correspondiente
		EmailRequest request = null;
		try {
			request = JsonConverter.fromJson(message, EmailRequest.class);
		} catch (IOException e) {

			logger.error("Error to transform Json [{}] to EmailRequest entity [{}] [{}]", message, e.getMessage(), e);
			return;

		}

		/**
		 * @see Paso 2, enviamos el correo
		 */
		bussines.enviaCorreo(request);

	}

}
