package com.dla.dda.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

import com.dla.dda.bussines.EmailBussines;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.utils.transaction.TransactionState;

@Service
public class EmailRestService implements IEmailRestService {

	private static Logger logger = LoggerFactory.getLogger(EmailRestService.class);

	@Autowired
	private EmailBussines bussines;

	@Override
	public EmailResponse enviaCorreo(EmailRequest request) {

		TransactionState.Current().initialize();

		StopWatch watch = new StopWatch();
		watch.start();

		EmailResponse response = new EmailResponse();

		logger.info("Email Request [{}]", request);

		try {
			response = bussines.enviaCorreo(request);
		} catch (Exception e) {
			response.setRespuesta("false");
		}

		if (watch.isRunning())
			watch.stop();

		logger.info("Response [{}]", response);
		logger.info("Total time [{}]", watch.getTotalTimeSeconds());

		return response;

	}

}
