package com.dla.dda.rest;

import java.io.InputStream;

import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.bussines.ProyectoAutorizacionCorreoBussines;
import com.dla.dda.domain.model.request.EmailAutorizacionRequest;
import com.dla.dda.domain.model.response.EmailResponse;

@Service
public class ProyectoAutorizaEmailsRestService implements
		IProyectoAutorizaEmailsRestService {

	private static Logger logger = LoggerFactory
			.getLogger(ProyectoAutorizaEmailsRestService.class);

	@Autowired
	private ProyectoAutorizacionCorreoBussines bussines;

	@Override
	public EmailResponse procesaEmailRequest(MultipartBody body) {

		EmailAutorizacionRequest request = body.getAttachmentObject("root",
				EmailAutorizacionRequest.class);
		
		InputStream stream = body.getAttachmentObject("binario",
				InputStream.class);

		logger.info("CorreoRestService.enviaCorreo request [{}]", request);

		return bussines.enviaCorreo(request, stream);

	}

}
