package com.dla.dda.bussines;

import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.constants.CorreoAutorizacionTypes;
import com.dla.dda.domain.model.email.EmailModelVO;
import com.dla.dda.domain.model.email.MessageAttachment;
import com.dla.dda.domain.model.request.EmailAutorizacionRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.utils.email.client.EmailService;

@Service
public class ProyectoAutorizacionCorreoBussines {

	// Se agrega el tipo de servicio a enviar
	@Qualifier("autorizacionEmailAviso")
	@Autowired
	private EmailService serviceAviso;

	@Qualifier("autorizacionEmailNotificacion")
	@Autowired
	private EmailService serviceNotificacion;

	@Qualifier("autorizacionEmailReporte")
	@Autowired
	private EmailService serviceReporte;

	@Qualifier("dlaEmailService")
	@Autowired
	private EmailService service;

	private static Logger logger = LoggerFactory
			.getLogger(ProyectoAutorizacionCorreoBussines.class);

	public EmailResponse enviaCorreo(EmailAutorizacionRequest request,
			InputStream attachment) {

		EmailResponse response = new EmailResponse();
		response.setRespuesta("true");

		EmailModelVO model = new EmailModelVO();

		try {

			if (attachment != null) {
				byte[] targetArray = new byte[attachment.available()];
				attachment.read(targetArray);

				request.setContentType(request.getContentType());
				request.setIos(new ByteArrayResource(targetArray));

				attachment.close();
			}

			model.setRequest(request);

			MessageAttachment messageAttachment = new MessageAttachment();
			messageAttachment.setToAddres(request.getDestinatarios());
			messageAttachment.setSubject(request.getSubject());
			messageAttachment.setFromAdddres(request.getUserName());
			messageAttachment.setAttachmentFilename(request
					.getAttachmentFilename());
			messageAttachment.setContentType(request.getContentType());
			messageAttachment.setIos(request.getIos());

			sendMessage(model, messageAttachment);

		} catch (Exception e) {
			logger.error("Error envio correo:  [{}]", e);
			response.setRespuesta("false");
		}

		return response;
	}

	private void sendMessage(EmailModelVO modeloCorreo,
			MessageAttachment attachment) {

		CorreoAutorizacionTypes tipoCorreo = ((EmailAutorizacionRequest) modeloCorreo
				.getRequest()).getTipoCorreo();

		switch (tipoCorreo) {
		case AVISO:
			logger.debug("AVISO");
			serviceAviso.sendMessage(modeloCorreo, attachment);
			break;
		case NOTIFICACION:
			logger.debug("NOTIFICACION");
			serviceNotificacion.sendMessage(modeloCorreo, attachment);
			break;
		case REPORTE:
			logger.debug("REPORTE");
			serviceReporte.sendMessage(modeloCorreo, attachment);
			break;
		default:
			logger.debug("DEFAULT DESDE DLA");
			service.sendMessage(modeloCorreo, attachment);
			break;
		}

	}

}
