package com.dla.dda.services;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.dla.dda.domain.constants.EstatusEstudio;
import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.catalogs.DdaCEstudio;

/**
 * @see Servicio para realizar las operaciones relacionadas a los estudios
 * @author montieln
 *
 */

@Repository
public class EstudiosService {

	@Autowired
	private BaseDAO dao;

	final private static Logger logger = LoggerFactory.getLogger(EstudiosService.class);

	/**
	 * @see Servicio que nos trae los estudios de DDA
	 * @param request
	 * @return
	 */
	// Se le agrega transactional para que no pierda la sesion
	@Transactional
	public List<DdaCEstudio> findEstudios(QueryRequest request) {

		// Si viene null lo ponemos por default
		EstatusEstudio status = (request.getEstatus() == null) ? EstatusEstudio.UNKNOW : request.getEstatus();

		Criteria criteria = dao.createCriteria(DdaCEstudio.class);

		switch (status) {
		case AUTORIZADO:
			criteria.add(Restrictions.isNotNull("idSap"));
			break;
		case VIRTUAL:
			criteria.add(Restrictions.isNull("idSap"));
			break;
		case UNKNOW:
			break;
		default:
			break;

		}

		criteria.addOrder(Order.desc("descEstudio"));

		List<DdaCEstudio> estudios = dao.getResultsByCriteria(criteria);

		return estudios;
	}

	@Transactional
	public List<DdaCEstudio> findEstudiosByNombre(QueryRequest request) {

		// Si viene null lo ponemos por default
		EstatusEstudio status = (request.getEstatus() == null) ? EstatusEstudio.UNKNOW : request.getEstatus();

		Criteria criteria = dao.createCriteria(DdaCEstudio.class);

		switch (status) {
		case AUTORIZADO:

			criteria.add(Restrictions.isNotNull("idSap"));
			break;
		case VIRTUAL:
			criteria.add(Restrictions.isNull("idSap"));
			break;
		case UNKNOW:
			break;
		default:
			break;

		}

		criteria.add(Restrictions.like("descEstudio", "" + request.getPattern() + "", MatchMode.ANYWHERE));

		criteria.addOrder(Order.desc("descEstudio"));

		List<DdaCEstudio> estudios = dao.getResultsByCriteria(criteria);

		return estudios;
	}

}
