package com.dla.dda.utils.spring;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @see Esta clase sirve para obtener refrencias a los beans que estan
 *      declarados en el application context de Spring, solo usar en escenarios
 *      en donde no se pueda obtener de manera sencilla la referncia a un bean.
 * 
 * @author nmontielh
 */
@Component
public final class BeanProvider implements ApplicationContextAware {

	private static final BeanProvider instance;

	static {
		instance = new BeanProvider();
	}

	private static ApplicationContext ctx;

	/**
	 * Metodo Builder.
	 * 
	 * @return Una unica instancia del BenaProvider
	 */
	public static BeanProvider getInstance() {
		return instance;
	}

	/**
	 * Regresa un bean por su id.
	 * 
	 * @param name
	 *            Id del bean a regresar
	 * @return Un bean del application context.
	 */
	public static Object getBean(String name) {
		return ctx.getBean(name);
	}

	/**
	 * Regresa un bean por su clase.
	 * 
	 * @param clazz
	 *            Clase del bean a regresar
	 * @return Un bean del application context.
	 */
	public static <T> T getBean(Class<T> clazz) {
		return ctx.getBean(clazz);
	}

	public static <T> T getBean(String s, Class<T> clazz) {
		return ctx.getBean(s, clazz);
	}

	@Override
	public void setApplicationContext(ApplicationContext ctx)
			throws BeansException {
		BeanProvider.ctx = ctx;
	}
}