package com.dla.dda.utils.test.client;

import java.io.IOException;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import com.dla.dda.domain.constants.Operacion;
import com.dla.dda.domain.model.email.DetalleCorreoVO;
import com.dla.dda.domain.model.email.EmailModelVO;
import com.dla.dda.domain.model.email.MessageAttachment;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.utils.email.client.EmailService;
import com.dla.dda.utils.json.JsonConverter;

/**
 * @see Prueba unitaria para enviar los correos
 * @author montieln
 *
 */
@ContextConfiguration(locations = { "classpath:email-test-context.xml" })
public class EmailClientTest extends AbstractTestNGSpringContextTests {

	private Logger logger = LoggerFactory.getLogger(EmailClientTest.class);

	@Qualifier("autoziacionTemplate")
	@Autowired
	private EmailService emailService;

	@Test(enabled = false)
	public void sendEmailTest() throws IOException {

		// llenamos los destinatarios a los que debemos enviar
		final String toAddres[] = { "irving.abigor@gmail.com","lunaiy@globalhitss.com","dlaclarovideo.dda@gmail.com", "olveras@globalhitss.com" };

		// Creamos el objeto a llenar para crear el template, es lo que va en el
		// cuerpo del correo
		EmailModelVO model = new EmailModelVO();
	
		
		DetalleCorreoVO autorizacion = new DetalleCorreoVO();
		autorizacion.setNumeroContrato("NBCS00142A");
		autorizacion.setDescripcionEstudio("NBC");
		autorizacion.setVigencia("hoy - manana");
		autorizacion.setMonto("6352999.974");
		autorizacion.setNoTitulos("772");
		
		EmailRequest request = new EmailRequest();
		final String destinatarios[] = { "irving.abigor@gmail.com","lunaiy@globalhitss.com","dlaclarovideo.dda@gmail.com", "olveras@globalhitss.com","lopezedgj@globalhitss.com" };
		String body=JsonConverter.toJson(autorizacion);
		logger.debug("body [{}]",body);
		request.setDate("22-febrero-2015");
		request.setName("yussel luna");
		request.setToCompany("DLA-Derechos de Autor");
		request.setUserName("irving.abigor@gmail.com");
		request.setDestinatarios(destinatarios);
		request.setSubject("DLA-Derechos de Autor desde DLA");
		request.setBody(body);
		request.setOperacion(Operacion.CONTRATO);
		request.setEtiqueta("soy la etiqueta en ");
		model.setRequest(request);
		
		// Creamos el objeto que puede o no incluir adjuntos, este objeto
		// configura el envio del correo
		MessageAttachment messageAttachment = new MessageAttachment();

		// agregamos los destinatarios
		messageAttachment.setToAddres(toAddres);
		messageAttachment.setSubject("DLA-Derechos de Autor");
		messageAttachment.setFromAdddres("dlaclarovideo.dda@gmail.com");
		
		
		model.setAutorizacion(JsonConverter.fromJson(body, DetalleCorreoVO.class));
		

		logger.info("Sending email [{}] [{}]", model, messageAttachment);

		emailService.sendMessage(model, messageAttachment);
		

	}
	


}
