/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.persistence.dao;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="dlaDAO")
@Transactional(value="dlaTM")
public class BaseDAO {
    private Logger logger = LoggerFactory.getLogger(BaseDAO.class);
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    @Qualifier(value="sessionFactory")
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public <T> Serializable save(T entity, Class<T> entityClass) throws IOException {
        this.logger.debug("saving {}", entity);
        return this.getSessionFactory().getCurrentSession().save(entity);
    }

    public <T> void saveOrUpdate(T entity, Class<T> entityClass) throws IOException {
        this.logger.debug("saveOrUpdate {}", entity);
        try {
            this.getSessionFactory().getCurrentSession().saveOrUpdate(entity);
        }
        catch (Exception e) {
            this.logger.error("Error {}", (Object)e.getMessage());
            this.logger.debug("merging {}", entity);
            this.getSessionFactory().getCurrentSession().merge(entity);
        }
    }

    public <T> void update(T entity, Class<T> entityClass) throws IOException {
        this.logger.debug("update {}", entity);
        try {
            this.getSessionFactory().getCurrentSession().update(entity);
        }
        catch (Exception e) {
            this.logger.error("Error {}", (Object)e.getMessage());
            this.logger.debug("merging {}", entity);
            this.getSessionFactory().getCurrentSession().merge(entity);
        }
    }

    public <T> void delete(T entity, Class<T> entityClass) throws IOException {
        this.logger.debug("delete {}", entity);
        this.getSessionFactory().getCurrentSession().delete(entity);
    }

    public <T> T findObjectByQuery(String queryName, Object[] parameters, Type[] types, Class<T> cl) {
        this.logger.debug("findObjectByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        query.setParameters(parameters, types);
        T resultado = null;
        List lista = query.list();
        if (!lista.isEmpty()) {
            resultado = (T)lista.get(0);
        }
        return resultado;
    }

    public <T> List<T> findListByQuery(String queryName, Object[] parameters, Type[] types, Class<T> cl) throws IOException {
        this.logger.debug("findListByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        query.setParameters(parameters, types);
        try {
            return query.list();
        }
        catch (IndexOutOfBoundsException ioe) {
            this.logger.error("Error {}", (Object)ioe.getMessage());
            throw new IOException(ioe);
        }
    }

    public <T> List<T> findListByQuery(String queryName, Map<String, Object> input, Class<T> cl) throws IOException {
        this.logger.debug("findListByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        for (String key : input.keySet()) {
            Object value = input.get(key);
            query.setParameter(key, value);
        }
        try {
            return query.list();
        }
        catch (IndexOutOfBoundsException ioe) {
            this.logger.error("Error {}", (Object)ioe.getMessage());
            throw new IOException(ioe);
        }
    }

    public <T> List<T> findListByQuery(String queryName, Class<T> cl) throws IOException {
        this.logger.debug("findListByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        try {
            return query.list();
        }
        catch (IndexOutOfBoundsException ioe) {
            this.logger.error("Error {}", (Object)ioe.getMessage());
            throw new IOException(ioe);
        }
    }

    public <T> List<T> findListByQuery(String queryName, FlushMode flushMode, Class<T> cl) throws IOException {
        this.logger.debug("findListByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        query.setFlushMode(flushMode);
        try {
            return query.list();
        }
        catch (IndexOutOfBoundsException ioe) {
            this.logger.error("Error {}", (Object)ioe.getMessage());
            throw new IOException(ioe);
        }
    }

    public <T> T read(Serializable key, Class<T> entityClass) throws IOException {
        this.logger.debug("read {}", (Object)key);
        return (T)this.getSessionFactory().getCurrentSession().get(entityClass, key);
    }

    public <T> T readForUpdate(Serializable key, Class<T> entityClass, LockMode lockMode) throws IOException {
        this.logger.debug("read {}", (Object)key);
        return (T)this.getSessionFactory().getCurrentSession().get(entityClass, key, new LockOptions(lockMode));
    }

    public void evictObject(Object obj) {
        this.logger.debug("evictObject:{}", obj);
        this.getSessionFactory().getCurrentSession().evict(obj);
    }

    public int executeBatchByQuery(String queryName, Object[] parameters, Type[] types) {
        this.logger.debug("executeBatchByQuery:{}", (Object)queryName);
        int resultado = 0;
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        int contador = 0;
        for (Type type : types) {
            if (type instanceof IntegerType) {
                query.setInteger(contador, ((Integer)parameters[contador]).intValue());
            }
            if (type instanceof StringType) {
                query.setString(contador, (String)parameters[contador]);
            }
            ++contador;
        }
        resultado = query.executeUpdate();
        return resultado;
    }

    public int executeBatchByQuery(String queryName, Object[] parameters, Type[] types, String inParamName, Collection inParameters) {
        return -1;
    }

    public <T> T findObjectByQuery(String queryName, Class<T> cl) {
        this.logger.debug("findObjectByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        T resultado = null;
        List lista = query.list();
        if (!lista.isEmpty()) {
            resultado = (T)lista.get(0);
        }
        return resultado;
    }

    @Transactional
    public <T> List<T> findListByQuery(String queryName, Class<T> cl, FlushMode mode) {
        this.logger.debug("findObjectByQuery {}", (Object)queryName);
        Query query = this.getSessionFactory().getCurrentSession().getNamedQuery(queryName);
        query.setFlushMode(FlushMode.MANUAL);
        return query.list();
    }

    public void flush() {
        this.getSessionFactory().getCurrentSession().flush();
    }

    public void clear() {
        this.getSessionFactory().getCurrentSession().clear();
    }

    public <T> Criteria createCriteria(Class<T> cl) {
        return this.getSessionFactory().getCurrentSession().createCriteria(cl);
    }

    public <T> List<T> getResultsByCriteria(Criteria criteria) {
        return criteria.list();
    }
}

