/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.persistence.model;

import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.persistence.model.DdaTContratoTerminoPago;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="DDA_T_CONTRATO_TERMINO")
public class DdaTContratoTermino
implements Serializable {
    private Long idContrato;
    private DdaTContrato ddaTContrato;
    private String anticipoMonto;
    private Date anticipoFecha;
    private String anticipoComentario;
    private String tipoPago;
    private String tipoPredefinido;
    private String comentarioGral;
    private String totalTitulos;
    private Set<DdaTContratoTerminoPago> ddaTContratoTerminoPagos = new HashSet<DdaTContratoTerminoPago>(0);

    public DdaTContratoTermino() {
    }

    public DdaTContratoTermino(DdaTContrato ddaTContrato) {
        this.ddaTContrato = ddaTContrato;
    }

    public DdaTContratoTermino(DdaTContrato ddaTContrato, String anticipoMonto, Date anticipoFecha, String anticipoComentario, String tipoPago, String tipoPredefinido, String comentarioGral, String totalTitulos, Set<DdaTContratoTerminoPago> ddaTContratoTerminoPagos) {
        this.ddaTContrato = ddaTContrato;
        this.anticipoMonto = anticipoMonto;
        this.anticipoFecha = anticipoFecha;
        this.anticipoComentario = anticipoComentario;
        this.tipoPago = tipoPago;
        this.tipoPredefinido = tipoPredefinido;
        this.comentarioGral = comentarioGral;
        this.totalTitulos = totalTitulos;
        this.ddaTContratoTerminoPagos = ddaTContratoTerminoPagos;
    }

    @GenericGenerator(name="generator", strategy="foreign", parameters={@Parameter(name="property", value="ddaTContrato")})
    @Id
    @GeneratedValue(generator="generator")
    @Column(name="ID_CONTRATO", unique=true, nullable=false, precision=38, scale=0)
    public Long getIdContrato() {
        return this.idContrato;
    }

    public void setIdContrato(Long idContrato) {
        this.idContrato = idContrato;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumn
    public DdaTContrato getDdaTContrato() {
        return this.ddaTContrato;
    }

    public void setDdaTContrato(DdaTContrato ddaTContrato) {
        this.ddaTContrato = ddaTContrato;
    }

    @Column(name="ANTICIPO_MONTO", length=25)
    public String getAnticipoMonto() {
        return this.anticipoMonto;
    }

    public void setAnticipoMonto(String anticipoMonto) {
        this.anticipoMonto = anticipoMonto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ANTICIPO_FECHA", length=7)
    public Date getAnticipoFecha() {
        return this.anticipoFecha;
    }

    public void setAnticipoFecha(Date anticipoFecha) {
        this.anticipoFecha = anticipoFecha;
    }

    @Column(name="ANTICIPO_COMENTARIO", length=100)
    public String getAnticipoComentario() {
        return this.anticipoComentario;
    }

    public void setAnticipoComentario(String anticipoComentario) {
        this.anticipoComentario = anticipoComentario;
    }

    @Column(name="TIPO_PAGO", length=15)
    public String getTipoPago() {
        return this.tipoPago;
    }

    public void setTipoPago(String tipoPago) {
        this.tipoPago = tipoPago;
    }

    @Column(name="TIPO_PREDEFINIDO", length=15)
    public String getTipoPredefinido() {
        return this.tipoPredefinido;
    }

    public void setTipoPredefinido(String tipoPredefinido) {
        this.tipoPredefinido = tipoPredefinido;
    }

    @Column(name="COMENTARIO_GRAL")
    public String getComentarioGral() {
        return this.comentarioGral;
    }

    public void setComentarioGral(String comentarioGral) {
        this.comentarioGral = comentarioGral;
    }

    @Column(name="TOTAL_TITULOS", length=25)
    public String getTotalTitulos() {
        return this.totalTitulos;
    }

    public void setTotalTitulos(String totalTitulos) {
        this.totalTitulos = totalTitulos;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ddaTContratoTermino")
    public Set<DdaTContratoTerminoPago> getDdaTContratoTerminoPagos() {
        return this.ddaTContratoTerminoPagos;
    }

    public void setDdaTContratoTerminoPagos(Set<DdaTContratoTerminoPago> ddaTContratoTerminoPagos) {
        this.ddaTContratoTerminoPagos = ddaTContratoTerminoPagos;
    }
}

