/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.utils;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.domain.model.response.AmortizacionResponse;
import com.dla.dda.domain.model.response.PresupuestoResponse;
import com.dla.dda.persistence.model.DdaTAmortizable;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.utils.date.DateUtils;
import com.dla.dda.utils.validator.CollectionsValidator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static Logger logger = LoggerFactory.getLogger(ErrorHandler.class);

    public static void addError(PresupuestoResponse response, ErrorCodes error) {
        List errors = CollectionsValidator.safeList((List)response.getError());
        errors.add(error);
        response.setError(errors);
    }

    public static void addError(PresupuestoResponse response, ErrorCodes error, String message) {
        ErrorUtils.setMessage((ErrorCodes)error, (String)message);
        List errors = CollectionsValidator.safeList((List)response.getError());
        errors.add(error);
        response.setError(errors);
    }

    public static void validate(PresupuestoResponse response, DdaTAmortizable data, String message) {
        if (data == null || data.getMonto() == null || data.getMonto().isEmpty()) {
            ErrorCodes error = ErrorCodes.DATA_NOT_EXIST;
            ErrorUtils.setMessage((ErrorCodes)error, (String)message);
            List errors = CollectionsValidator.safeList((List)response.getError());
            errors.add(error);
            response.setError(errors);
            logger.error("Error [{}] [{}] [{}]", new Object[]{error, error.getCode(), error.getDetail()});
        }
    }

    public static void validate(PresupuestoResponse response, DdaTContrato data, String message) {
        if (data == null || data.getDdaTApartado() == null || data.getDdaTApartado().getIdApartado() == null) {
            ErrorCodes error = ErrorCodes.DATA_NOT_EXIST;
            ErrorUtils.setMessage((ErrorCodes)error, (String)message);
            List errors = CollectionsValidator.safeList((List)response.getError());
            errors.add(error);
            response.setError(errors);
            logger.error("Error [{}] [{}]", (Object)error.getCode(), (Object)error.getDetail());
        }
    }

    public static void validate(PresupuestoResponse response, String messageOk, String messageError) {
        Double estudioTotal = response.getContratoEstudio() + response.getValorContrato();
        logger.info(" estudioTotal [{}] = contratoEstudio [{}] + valorContrato [{}]", new Object[]{estudioTotal, response.getContratoEstudio(), response.getValorContrato()});
        ErrorCodes code = ErrorCodes.UNKNOW_ERROR;
        List errors = CollectionsValidator.safeList((List)response.getError());
        Boolean errosExist = errors.size() > 0;
        Boolean cumplePresupuesto = estudioTotal <= response.getAmortizableEstudio();
        logger.info(" cumplePresupuesto [{}] = ( estudioTotal [{}] <= amortizableEstudio [{}] )", new Object[]{cumplePresupuesto, estudioTotal, response.getAmortizableEstudio()});
        logger.info(" Cumple presupuesto [{}] errores [{}]", (Object)cumplePresupuesto, (Object)errors.size());
        if (cumplePresupuesto.booleanValue() && !errosExist.booleanValue()) {
            code = ErrorCodes.SUCCESS;
            ErrorUtils.setMessage((ErrorCodes)code, (String)messageOk);
        } else if (!cumplePresupuesto.booleanValue() && !errosExist.booleanValue()) {
            code = ErrorCodes.BUSSINES_ERROR;
        } else {
            code = ErrorCodes.UNEXPECTED_EROR;
            ErrorUtils.setMessage((ErrorCodes)code, (String)messageError);
        }
        response.setMsg(code.getDetail());
        response.setEstatus(code.getCode());
        logger.info("validate [{}] [{}]", (Object)code.getCode(), (Object)code.getDetail());
    }

    public static void validate(PresupuestoResponse response, Date inicioCto, Date sincronizacion) {
        ErrorCodes code = ErrorCodes.UNKNOW_ERROR;
        if (sincronizacion == null || inicioCto == null) {
            code = ErrorCodes.UNEXPECTED_EROR;
            ErrorUtils.setMessage((ErrorCodes)code, (String)"Fecha nula");
        } else if (DateUtils.compararFechasSincronizacion((Date)inicioCto, (Date)sincronizacion)) {
            code = ErrorCodes.SUCCESS;
            ErrorUtils.setMessage((ErrorCodes)code, (String)"Fecha de inicio de contrato es valida (es menor a la fecha de sync sap)");
        }
        response.setMsg(code.getDetail());
        response.setEstatus(code.getCode());
        logger.info("validate [{}] [{}]", (Object)code.getCode(), (Object)code.getDetail());
    }

    public static void addError(AmortizacionResponse response, PresupuestoResponse errorList) {
        List errors = CollectionsValidator.safeList((List)errorList.getError());
        if (errors.isEmpty()) {
            errorList.setEstatus(ErrorCodes.SUCCESS_PROCESS.getCode());
            errorList.setMsg(ErrorCodes.SUCCESS_PROCESS.getDetail());
        } else {
            errorList.setEstatus(ErrorCodes.FAIL.getCode());
            errorList.setMsg(ErrorCodes.FAIL.getDetail());
        }
        response = response != null ? response : new AmortizacionResponse();
        response.setResponseCode(errorList.getEstatus());
        response.setDetail(errorList.getMsg());
        response.setError(errorList.getError());
    }
}

