/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.utils.email.client;

import com.dla.dda.domain.model.email.MessageAttachment;
import java.io.Serializable;
import java.util.HashMap;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class EmailService {
    private Logger logger = LoggerFactory.getLogger(EmailService.class);
    private JavaMailSenderImpl mailSender;
    private SimpleMailMessage templateMessage;
    private VelocityEngine velocityEngine;
    private String templatePath;

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    public void setTemplateMessage(SimpleMailMessage templateMessage) {
        this.templateMessage = templateMessage;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void sendMessage(Serializable emailModel, MessageAttachment messageAttachment) {
        this.logger.info("sending message [{}]", (Object)messageAttachment);
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            if (messageAttachment.getFromAdddres() != null) {
                helper.setFrom(messageAttachment.getFromAdddres());
            } else {
                helper.setFrom(this.templateMessage.getFrom());
            }
            if (messageAttachment.getSubject() != null) {
                helper.setSubject(messageAttachment.getSubject());
            } else {
                helper.setSubject(this.templateMessage.getSubject());
            }
            String texto = this.createText(emailModel);
            helper.setText(texto, true);
            if (messageAttachment.getToAddres() != null && messageAttachment.getToAddres().length > 0) {
                helper.setTo(messageAttachment.getToAddres());
            } else {
                helper.setTo(this.templateMessage.getTo());
            }
            if (messageAttachment.getAttachmentFilename() != null && messageAttachment.getIos() != null && messageAttachment.getContentType() != null) {
                helper.addAttachment(messageAttachment.getAttachmentFilename(), messageAttachment.getIos(), messageAttachment.getContentType());
            }
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
            this.mailSender.send(message);
        }
        catch (MessagingException e) {
            this.logger.error("hubo un error al enviar el correo:" + e.getMessage(), (Throwable)e);
        }
    }

    private String createText(Serializable emailModel) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("emailModel", emailModel);
        String texto = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)this.templatePath, model);
        return texto;
    }
}

