/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.transforms;

import com.dla.dda.domain.contrato.FeesFlat;
import com.dla.dda.domain.contrato.FeesSuscriptor;
import com.dla.dda.domain.contrato.PeriodoFlat;
import com.dla.dda.domain.contrato.Rango;
import com.dla.dda.persistence.model.DdaTContratoPago;
import com.dla.dda.persistence.model.DdaTContratoPagoCateg;
import com.dla.dda.persistence.model.DdaTContratoPagoCosto;
import com.dla.dda.persistence.model.DdaTContratoPagoFlat;
import com.dla.dda.persistence.model.DdaTContratoPagoRango;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeesTransform {
    private static Logger logger = LoggerFactory.getLogger(FeesTransform.class);

    public static Map<String, Rango> transform(DdaTContratoPagoRango pagoRango, DdaTContratoPagoCosto pagoCosto, DdaTContratoPagoCateg pagoCateg) {
        HashMap<String, Rango> periodo = new HashMap<String, Rango>();
        String desde = pagoRango.getDesde();
        String hasta = pagoRango.getHasta();
        String costo = pagoCosto.getCosto();
        String categoria = pagoCateg.getDescCategoria();
        logger.info(" [{}] [{}] [{}] [{}]", new Object[]{categoria, desde, hasta, costo});
        Rango rango = new Rango();
        rango.setDesde(Integer.valueOf(desde));
        rango.setHasta(Integer.valueOf(hasta));
        rango.setValor(Double.valueOf(costo));
        periodo.put(categoria, rango);
        return periodo;
    }

    public static Map<String, List<PeriodoFlat>> transform(DdaTContratoPagoFlat pagoRango, DdaTContratoPagoCateg pagoCosto) {
        HashMap<String, List<PeriodoFlat>> categoria = new HashMap<String, List<PeriodoFlat>>();
        ArrayList<PeriodoFlat> periodos = new ArrayList<PeriodoFlat>();
        String costo = pagoRango.getCosto();
        String categoriaKey = pagoCosto.getDescCategoria();
        PeriodoFlat flat = new PeriodoFlat();
        if (costo != null) {
            flat.setValor(Double.valueOf(costo));
        }
        periodos.add(flat);
        categoria.put(categoriaKey, periodos);
        return categoria;
    }

    public static void addPeriodoSuscripcion(Map<String, Rango> periodo, Map<String, List<Rango>> periodos) {
        Set<String> keys = periodo.keySet();
        for (String categoriaKey : keys) {
            List<Rango> rangoPeriodos = periodos.get(categoriaKey);
            Rango rangoEntity = periodo.get(categoriaKey);
            if (rangoPeriodos != null) {
                rangoPeriodos.add(rangoEntity);
                periodos.put(categoriaKey, rangoPeriodos);
                continue;
            }
            ArrayList<Rango> rangoPeriodoNew = new ArrayList<Rango>();
            rangoPeriodoNew.add(rangoEntity);
            periodos.put(categoriaKey, rangoPeriodoNew);
        }
    }

    public static FeesSuscriptor adapt(DdaTContratoPago pago, Map<String, List<Rango>> periodosSuscripcion) {
        FeesSuscriptor suscriptor = new FeesSuscriptor();
        suscriptor.setFechaFin(pago.getFechaFin());
        suscriptor.setFechaInicio(pago.getFechaInicio());
        suscriptor.setIdTipoSuscriptor(pago.getIdTipoSuscriptor());
        suscriptor.setPeriodos(periodosSuscripcion);
        return suscriptor;
    }

    public static void adaptPeriodosFlatFees(Map<String, List<PeriodoFlat>> periodosFlatCompletos, DdaTContratoPago pago, Map<String, List<PeriodoFlat>> periodosFlat) {
        if (periodosFlat != null) {
            for (Map.Entry<String, List<PeriodoFlat>> entry : periodosFlat.entrySet()) {
                String categoria = entry.getKey();
                List<PeriodoFlat> periodosFlatFees = entry.getValue();
                for (PeriodoFlat periodo : periodosFlatFees) {
                    periodo.setFechaFin(pago.getFechaFin());
                    periodo.setFechaInicio(pago.getFechaInicio());
                }
                List<PeriodoFlat> periodoFlat = periodosFlatCompletos.get(categoria);
                if (periodoFlat == null) {
                    periodoFlat = new ArrayList<PeriodoFlat>();
                }
                periodoFlat.addAll(periodosFlatFees);
                periodosFlatCompletos.put(categoria, periodoFlat);
            }
        }
    }

    public static FeesFlat adaptPeridosFlatFees(DdaTContratoPago pago, Map<String, List<PeriodoFlat>> periodos) {
        FeesFlat flat = new FeesFlat();
        Date fechaFin = pago.getFechaFin();
        Date fechaInicio = pago.getFechaInicio();
        Set<String> keys = periodos.keySet();
        for (String key : keys) {
            List<PeriodoFlat> periodosFlat = periodos.get(key);
            for (PeriodoFlat entity : periodosFlat) {
                int index = periodosFlat.indexOf(entity);
                entity.setFechaInicio(fechaInicio);
                entity.setFechaFin(fechaFin);
                periodosFlat.set(index, entity);
            }
            periodos.put(key, periodosFlat);
        }
        flat.setPeriodos(periodos);
        return flat;
    }

    public static void addPeriodoFlat(Map<String, List<PeriodoFlat>> categoria, Map<String, List<PeriodoFlat>> periodos) {
        Set<String> keys = categoria.keySet();
        for (String categoriaKey : keys) {
            List<PeriodoFlat> rangoPeriodos = periodos.get(categoriaKey);
            List<PeriodoFlat> periodoCat = categoria.get(categoriaKey);
            if (rangoPeriodos != null) {
                rangoPeriodos.addAll(periodoCat);
                periodos.put(categoriaKey, rangoPeriodos);
                continue;
            }
            periodos.put(categoriaKey, periodoCat);
        }
    }
}

