package com.dla.dda.domain.model.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.dla.dda.domain.constants.ErrorCodes;

/**
 * @see Modelo que representa la respuesta al proceso de la generacion de la
 *      amortizacion
 * @author montieln
 *
 */
public class AmortizacionResponse implements Serializable {

	private static final long serialVersionUID = 1L;

	private String responseCode;

	private String detail;

	private List<ErrorCodes> error = new ArrayList<>();

	public AmortizacionResponse() {
		super();

	}

	public List<ErrorCodes> getError() {
		return error;
	}

	public void setError(List<ErrorCodes> error) {
		this.error = error;
	}

	public String getResponseCode() {
		return responseCode;
	}

	public void setResponseCode(String responseCode) {
		this.responseCode = responseCode;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	@Override
	public String toString() {
		return "AmortizacionResponse [responseCode=" + responseCode + ", detail=" + detail + ", error=" + error + "]";
	}

}
