package com.dla.dda.jms.sender.test;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;

import org.fusesource.mqtt.cli.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

/**
 * @see Publisher para los Queue o Topicos, solo manda String en formato json
 * @author montieln
 *
 */
public class JMSPublisher {

	private JmsTemplate jmsTemplate;

	private Queue destination;

	private static Logger logger = LoggerFactory.getLogger(JMSPublisher.class);

	public void setDestination(Queue destination) {
		this.destination = destination;
	}

	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

	/**
	 * @see Metodo que envia mensajes en formato cadena al queue especificado en
	 *      destination
	 * @param payload
	 * @throws JMSException
	 */
	public void send(final String payload) throws JMSException {

		logger.info("Publishing to [{}] message [{}]", destination.getQueueName(), payload);

		this.jmsTemplate.send(this.destination, new MessageCreator() {

			public Message createMessage(Session session) throws JMSException {

				Message message = session.createTextMessage(payload);

				return message;
			}

		});

	}

}
