package com.dla.dda.scheduler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.services.SeguimientoEmailService;

/**
 * servicio de prueba para los crons
 * 
 * @author montieln
 *
 */

@Service
@Qualifier("recordatorioEmailCron")
public class RecordatorioEmailCron implements ITask {

	private static Logger logger = LoggerFactory.getLogger(RecordatorioEmailCron.class);
	
	@Autowired
	private SeguimientoEmailService seguimientoEmailService;
	
	@Override
	public void execute() {
		
		logger.info("Seguimiento de correos pendientes.");
		
		try {
			seguimientoEmailService.seguimientoDeCorreosPendientes();
		} catch (DLAIntegrationException e) {
			logger.error("Error en el seguimiento de correos [{}]", e.getMessage(), e);
		}


	}

}
